/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.socialservice;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.authorization.utils.user.GCubeUser;
import org.gcube.common.authorization.utils.user.User;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialService {
    private static final String RESOURCE = "jersey-servlet";
    private static final String SERVICE_NAME = "SocialNetworking";
    private static final String SERVICE_CLASS = "Portal";
    private static Logger logger = LoggerFactory.getLogger(SocialService.class);
    private String serviceBasePath;
    private static Map<String, SocialService> socialServicePerContext = new HashMap<String, SocialService>();
    protected static final String SOCIAL_SERVICE_GET_OAUTH_USER_PROFILE_PATH = "2/users/get-oauth-profile";
    protected static final String RESPONSE_SUCCESS_KEY = "success";
    protected static final String RESPONSE_MESSAGE_KEY = "message";
    protected static final String RESPONSE_RESULT_KEY = "result";

    public static SocialService getSocialService() throws Exception {
        SecretManager secretManager = SecretManagerProvider.instance.get();
        String context = secretManager.getContext();
        SocialService socialService = socialServicePerContext.get(context);
        if (socialService == null) {
            socialService = new SocialService();
            socialServicePerContext.put(context, socialService);
        }
        return socialService;
    }

    private SocialService() throws Exception {
        this.getServiceBasePathViaGCoreEndpoint();
    }

    protected void getServiceBasePathViaGCoreEndpoint() throws Exception {
        SecretManager secretManager = SecretManagerProvider.instance.get();
        try {
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition(String.format("$resource/Profile/ServiceClass/text() eq '%s'", SERVICE_CLASS));
            query.addCondition("$resource/Profile/DeploymentData/Status/text() eq 'ready'");
            query.addCondition(String.format("$resource/Profile/ServiceName/text() eq '%s'", SERVICE_NAME));
            query.setResult("$resource/Profile/AccessPoint/RunningInstanceInterfaces//Endpoint[@EntryName/string() eq \"jersey-servlet\"]/text()");
            DiscoveryClient client = ICFactory.client();
            List endpoints = client.submit((Query)query);
            if (endpoints == null || endpoints.isEmpty()) {
                throw new Exception("Cannot retrieve the GCoreEndpoint SERVICE_NAME: SocialNetworking, SERVICE_CLASSE: Portal, in scope: " + secretManager.getContext());
            }
            this.serviceBasePath = (String)endpoints.get(0);
            if (this.serviceBasePath == null) {
                throw new Exception("Endpoint:jersey-servlet, is null for SERVICE_NAME: SocialNetworking, SERVICE_CLASSE: Portal, in scope: " + secretManager.getContext());
            }
            this.serviceBasePath = this.serviceBasePath.endsWith("/") ? this.serviceBasePath : this.serviceBasePath + "/";
        }
        catch (Exception e) {
            String error = "An error occurred during GCoreEndpoint discovery, SERVICE_NAME: SocialNetworking, SERVICE_CLASSE: Portal, in scope: " + secretManager.getContext() + ".";
            logger.error(error, (Throwable)e);
            throw new Exception(error);
        }
    }

    public String getServiceBasePath() {
        return this.serviceBasePath;
    }

    public StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result;
    }

    public String getResultAsString(HttpURLConnection httpURLConnection) throws IOException {
        int responseCode = httpURLConnection.getResponseCode();
        if (responseCode >= Response.Status.BAD_REQUEST.getStatusCode()) {
            Response.Status status = Response.Status.fromStatusCode((int)responseCode);
            InputStream inputStream = httpURLConnection.getErrorStream();
            StringBuilder result = this.getStringBuilder(inputStream);
            logger.trace(result.toString());
            throw new WebApplicationException(result.toString(), status);
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        String ret = this.getStringBuilder(inputStream).toString();
        logger.trace("Got Respose is {}", (Object)ret);
        return ret;
    }

    public User getUser(Secret secret) throws Exception {
        try {
            String socialServiceBasePath = SocialService.getSocialService().getServiceBasePath();
            GXHTTPStringRequest gxhttpStringRequest = GXHTTPStringRequest.newRequest((String)socialServiceBasePath);
            gxhttpStringRequest.from("authorization-utils");
            gxhttpStringRequest.header("Accept", "application/json");
            Map<String, String> authzHeaders = secret.getHTTPAuthorizationHeaders();
            for (String key : authzHeaders.keySet()) {
                gxhttpStringRequest.header(key, authzHeaders.get(key));
            }
            gxhttpStringRequest.path(SOCIAL_SERVICE_GET_OAUTH_USER_PROFILE_PATH);
            HttpURLConnection httpURLConnection = gxhttpStringRequest.get();
            String ret = this.getResultAsString(httpURLConnection);
            logger.trace("Got response from social service is {}", (Object)ret);
            ObjectMapper mapper = new ObjectMapper();
            return (User)mapper.readValue(ret, GCubeUser.class);
        }
        catch (Exception e) {
            throw new Exception("Unable to retrive User from Social Service", e);
        }
    }
}

