/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.user;

import java.util.Collection;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.common.authorization.utils.user.User;
import org.gcube.common.keycloak.model.AccessToken;

public class KeycloakUser
extends AccessToken
implements User {
    private static final long serialVersionUID = -7083648026885406300L;
    public static final String CLIENT_ID_PROPERTY_OLD_KEY = "clientId";
    public static final String CLIENT_ID_PROPERTY = "client_id";
    protected Collection<String> roles;
    protected Boolean application;

    @Override
    @JsonIgnore
    public String getUsername() {
        return this.getPreferredUsername();
    }

    @JsonIgnore
    protected String getClientId() {
        Object clientIdObj = this.getOtherClaims().get(CLIENT_ID_PROPERTY);
        if (clientIdObj == null) {
            clientIdObj = this.getOtherClaims().get(CLIENT_ID_PROPERTY_OLD_KEY);
        }
        return clientIdObj == null ? null : clientIdObj.toString();
    }

    @Override
    public boolean isApplication() {
        if (this.application == null) {
            this.application = this.getClientId() != null;
        }
        return this.application;
    }

    @Override
    @JsonIgnore
    public Collection<String> getRoles() {
        return this.roles;
    }

    @Override
    @JsonIgnore
    public void setRoles(Collection<String> roles) {
        this.roles = roles;
    }

    @Override
    public String getAbout() {
        return "";
    }

    @Override
    public String getFullName() {
        return this.getFullName(false);
    }

    @Override
    public String getFullName(boolean nameSurname) {
        if (this.isApplication()) {
            String clientID = this.getClientId();
            if (clientID == null) {
                clientID = this.getUsername();
            }
            return clientID;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean found = false;
        String surname = this.getFamilyName();
        String name = this.getGivenName();
        if (nameSurname) {
            if (name != null && name.trim().length() > 0) {
                stringBuffer.append(name.trim());
                found = true;
            }
            if (surname != null && surname.trim().length() > 0) {
                if (found) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(surname.trim());
                found = true;
            }
        } else {
            if (surname != null && surname.trim().length() > 0) {
                stringBuffer.append(surname.trim());
                found = true;
            }
            if (name != null && name.trim().length() > 0) {
                if (found) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(name.trim());
                found = true;
            }
        }
        return stringBuffer.toString();
    }
}

