
package org.gcube.common.authorization.library.aspect;

import java.lang.reflect.Method;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.gcube.common.authorization.library.annotations.AuthorizationControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AuthorizationAspect {

	Logger log = LoggerFactory.getLogger(AuthorizationAspect.class);
	
	@Pointcut("@annotation(org.gcube.common.authorization.library.annotations.AuthorizationControl)")
	public void authorizationEntyPoint() {
	}
	
	@Pointcut("execution(* *(..))")
	public void atExecution() {
	}
	
	@Before("authorizationEntyPoint() && atExecution()")
	public void before(JoinPoint joinPoint) {
		MethodSignature signature = (MethodSignature) joinPoint.getSignature();
	    Method method = signature.getMethod();
		AuthorizationControl authAnn = (AuthorizationControl) method.getAnnotation(AuthorizationControl.class);
		log.info("aspect before with annotation {} and value {} in method {}", authAnn.annotationType(), authAnn.check(), method.getName());
	}
	
}
