package org.gcube.common.security;

import java.util.ArrayList;
import java.util.List;

public class Owner {

	private String clientId;
	private List<String> roles = new ArrayList<String>();
	
	boolean externalClient;
	
	private String email;
	private String firstName;
	private String lastName;
	
	//"name", as the client pretty name, e.g. Catalogue for gcat, Workspace for storage-hub
	private String clientName; 
	
	//username of the user who requested such client
	private String contactPerson; 
	
	//the name of the organisation / community using such client. D4Science will be used for internal clients.
	private String contactOrganisation;		
		
	
	public Owner(String clientId, List<String> roles, boolean external) {
		super();
		this.clientId = clientId;
		this.roles = roles;
		this.externalClient = external;
	}
	
	public Owner(String clientId, List<String> roles, String email, String firstName, String lastName,boolean external) {
		super();
		this.clientId = clientId;
		this.roles = roles;
		this.email = email;
		this.firstName = firstName;
		this.lastName = lastName;
		this.externalClient = external;
	}

	public String getId() {
		return clientId;
	}

	public List<String> getRoles() {
		return roles;
	}

	public String getEmail() {
		return email;
	}
	
	public String getFirstName() {
		return firstName;
	}
	
	public String getLastName() {
		return lastName;
	}

	public boolean isExternalClient() {
		return externalClient;
	}

	public String getClientName() {
		return clientName;
	}

	public void setClientName(String clientName) {
		this.clientName = clientName;
	}

	public String getContactPerson() {
		return contactPerson;
	}

	public void setContactPerson(String contactPerson) {
		this.contactPerson = contactPerson;
	}

	public String getContactOrganisation() {
		return contactOrganisation;
	}

	public void setContactOrganisation(String contactOrganisation) {
		this.contactOrganisation = contactOrganisation;
	}
	
}
