package org.gcube.common.security.providers;

import org.gcube.common.security.secrets.Secret;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class SecretManagerProvider {

	public static SecretManagerProvider instance = new SecretManagerProvider();
	
	// Thread local variable containing each thread's ID
    private static final InheritableThreadLocal<Secret> thread = new InheritableThreadLocal<Secret>() {

		@Override
		protected Secret initialValue() {
			return null;
		}

	};
	
	private SecretManagerProvider(){}
    
	public Secret get(){
		Secret secret = thread.get();
		return secret;
	}
	
	public void set(Secret secret){
		thread.set(secret);
	}
	
	public void reset(){
		thread.remove();
	}
	
}
