package org.gcube.context;

import java.io.File;
import java.util.LinkedHashMap;

import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.server.managers.scope.ScopeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public abstract class ContextElaborator {
	
	protected Logger logger = LoggerFactory.getLogger(this.getClass());
	
	public ContextElaborator(){
		
	}
	
	public void all(File voFile) throws Exception{
		try {
			
			LinkedHashMap<String, ScopeBean> map = ScopeManager.readScopes(voFile.getAbsolutePath());
			for(String scope : map.keySet()) {
				try {
					String context = map.get(scope).toString();
					logger.debug("Going to elaborate {}", context);
					elaborateContext(map.get(scope));
				}catch (Exception e) {
					logger.error("Error while elaborating {}", scope, e);
					throw e;
				}
			}
		} catch (Exception ex) {
			throw ex;
		}
	}

	protected abstract void elaborateContext(ScopeBean scopeBean) throws Exception;
	
}
