/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.context;

import java.io.File;
import java.util.LinkedHashMap;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.server.managers.scope.ScopeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextElaborator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void all(File voFile) throws Exception {
        LinkedHashMap map = ScopeManager.readScopes((String)voFile.getAbsolutePath());
        for (String scope : map.keySet()) {
            try {
                String context = ((ScopeBean)map.get(scope)).toString();
                this.logger.debug("Going to elaborate {}", (Object)context);
                this.elaborateContext((ScopeBean)map.get(scope));
            }
            catch (Exception e) {
                this.logger.error("Error while elaborating {}", (Object)scope, (Object)e);
                throw e;
                return;
            }
        }
    }

    protected abstract void elaborateContext(ScopeBean var1) throws Exception;
}

