/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.context.authorization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.support.server.managers.scope.ScopeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokensUtil {
    private static final Logger logger = LoggerFactory.getLogger(TokensUtil.class);

    public static Map<String, String> getTokenForContexts(File voFile, String username, String serviceName) throws Exception {
        HashMap<String, String> scopeTokenMap = new HashMap<String, String>();
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        LinkedHashMap map = ScopeManager.readScopes((String)voFile.getAbsolutePath());
        for (String scope : map.keySet()) {
            try {
                String context = ((ScopeBean)map.get(scope)).toString();
                System.out.println("Going to generate Token for Context " + context);
                logger.info("Going to generate Token for Context {}", (Object)context);
                UserInfo userInfo = new UserInfo(username, new ArrayList());
                String userToken = Constants.authorizationService().generateUserToken(userInfo, context);
                SecurityTokenProvider.instance.set(userToken);
                String generatedToken = Constants.authorizationService().generateExternalServiceToken(serviceName);
                scopeTokenMap.put(context, generatedToken);
                objectNode.put(context, generatedToken);
                logger.info("Token for Context {} is {}", (Object)context, (Object)generatedToken);
            }
            catch (Exception e) {
                logger.error("Error while elaborating {}", (Object)scope, (Object)e);
                throw e;
            }
            finally {
                SecurityTokenProvider.instance.reset();
            }
        }
        File tokenFile = new File("tokens-" + serviceName + ".json");
        objectMapper.writeValue(tokenFile, (Object)objectNode);
        return scopeTokenMap;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("Please provide 'vo file path' as first argument 'username' as second and 'external application name' as third");
            return;
        }
        File voFile = new File(args[0]);
        if (!voFile.exists()) {
            System.out.println(args[0] + " does not exists");
            return;
        }
        TokensUtil.getTokenForContexts(voFile, args[1], args[2]);
    }
}

