/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.context;

import java.util.LinkedHashMap;
import java.util.TreeSet;
import org.gcube.resourcemanagement.support.server.managers.context.ContextManager;
import org.gcube.resourcemanagement.support.shared.types.datamodel.D4SEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextElaborator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void all() throws Exception {
        LinkedHashMap contexts = ContextManager.readContextsWithUUIDs();
        TreeSet orderedContextNames = new TreeSet(contexts.keySet());
        for (String context : orderedContextNames) {
            D4SEnvironment d4sEnvironment = (D4SEnvironment)contexts.get(context);
            try {
                this.logger.debug("Going to elaborate {}", (Object)context);
                this.elaborateContext(d4sEnvironment);
            }
            catch (Exception e) {
                this.logger.error("Error while elaborating {}", (Object)context, (Object)e);
                throw e;
                return;
            }
        }
    }

    protected abstract void elaborateContext(D4SEnvironment var1) throws Exception;
}

