/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.dbinterface.types;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.types.Type;

public class Cast {
    private static GCUBELog logger = new GCUBELog(Cast.class);

    public static Object apply(Class javaClass, Type destination, Object value) throws Exception {
        if (!value.getClass().isAssignableFrom(javaClass)) {
            throw new Exception("value and origin Type are not compatible");
        }
        Type origin = Type.getTypeByJavaClass(javaClass);
        Object toReturn = null;
        try {
            switch (destination.getType()) {
                case INTEGER: {
                    toReturn = origin.toInteger(value);
                    break;
                }
                case STRING: 
                case TEXT: {
                    toReturn = origin.toString(value);
                    break;
                }
                case DATE: {
                    toReturn = origin.toDate(value, destination.getFormat());
                    break;
                }
                case TIME: {
                    toReturn = origin.toTime(value, destination.getFormat());
                    break;
                }
                case FLOAT: {
                    toReturn = Float.valueOf(origin.toReal(value));
                    break;
                }
                case LONG: {
                    toReturn = origin.toLong(value);
                    break;
                }
                case TIMESTAMP: {
                    toReturn = origin.toTimestamp(value);
                    break;
                }
                case BOOLEAN: {
                    toReturn = origin.toBoolean(value);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"error casting value", (Throwable)e);
            return null;
        }
        return toReturn;
    }
}

