/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.dbinterface.pool;

import java.sql.DriverManager;
import java.sql.SQLException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.pool.ObjectPool;

public class ConnectionPool
extends ObjectPool<DBSession> {
    private GCUBELog logger = new GCUBELog(ConnectionPool.class);
    private String dsn;
    private String usr;
    private String pwd;

    public ConnectionPool(String driver, String dsn, String usr, String pwd) {
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        this.dsn = dsn;
        this.usr = usr;
        this.pwd = pwd;
    }

    @Override
    protected DBSession create() {
        try {
            return new DBSession(DriverManager.getConnection(this.dsn, this.usr, this.pwd));
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public void expire(DBSession o) {
        try {
            o.closeConnection();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    @Override
    public boolean validate(DBSession o) {
        try {
            return !o.isConnectionClosed();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return false;
        }
    }
}

