/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.dbinterface.pool;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.gcube.common.dbinterface.Initializer;
import org.gcube.common.dbinterface.pool.ConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSession {
    private static Hashtable<Class, Class> queryMapping;
    protected static ConnectionPool connectionPool;
    public static String drivers;
    public static String entireUrl;
    private static final Logger logger;
    private Connection connection;

    public static void initialize(String basePackage, String username, String passwd, String dbPath) throws Exception {
        Initializer initializer;
        queryMapping = new Hashtable();
        logger.trace(basePackage + ".InitializerImpl");
        try {
            initializer = (Initializer)Class.forName(basePackage + ".InitializerImpl").newInstance();
        }
        catch (Exception e) {
            logger.error("impossible to retrieve initializer", (Throwable)e);
            throw e;
        }
        logger.trace("retrieving query mapping");
        Properties mappingProperties = initializer.getQueryMappingPropertiesStream();
        for (Map.Entry<Object, Object> entry : mappingProperties.entrySet()) {
            queryMapping.put(Class.forName((String)entry.getKey()), Class.forName((String)entry.getValue()));
        }
        initializer.initialize(username, passwd, dbPath);
        logger.debug(initializer.getEntireUrl());
        connectionPool = new ConnectionPool(initializer.getDriver(), initializer.getEntireUrl(), username, passwd);
        drivers = initializer.getDriver();
        entireUrl = initializer.getEntireUrl();
        DBSession session = DBSession.connect();
        initializer.postInitialization(session);
        session.release();
    }

    public static DBSession connect() throws Exception {
        return (DBSession)connectionPool.acquire();
    }

    protected DBSession(Connection conn) {
        this.connection = conn;
    }

    public void release() {
        try {
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            logger.warn("error in DBSessionPool");
        }
        connectionPool.release(this);
    }

    protected void closeConnection() throws Exception {
        this.connection.close();
    }

    public boolean isConnectionClosed() throws Exception {
        return this.connection.isClosed();
    }

    public void disableAutoCommit() throws Exception {
        this.connection.setAutoCommit(false);
    }

    public void commit() throws Exception {
        this.connection.commit();
    }

    public void rollback() throws Exception {
        this.connection.rollback();
    }

    public ResultSet execute(String query, boolean resultSetReuse) throws SQLException {
        logger.trace("executing query: " + query);
        Statement statement = null;
        statement = resultSetReuse ? this.connection.createStatement(1004, 1007) : this.connection.createStatement(1003, 1007);
        return statement.executeQuery(query);
    }

    public int executeUpdate(String query) throws SQLException {
        Statement statement = this.connection.createStatement();
        return statement.executeUpdate(query);
    }

    public PreparedStatement getPreparedStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    public static <QUERY> QUERY getImplementation(Class<QUERY> type) throws Exception {
        return (QUERY)queryMapping.get(type).newInstance();
    }

    public DatabaseMetaData getDBMetadata() throws Exception {
        return this.connection.getMetaData();
    }

    public Connection getConnection() {
        return this.connection;
    }

    static {
        logger = LoggerFactory.getLogger(DBSession.class);
    }
}

