package org.gcube.event.publisher;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventPublisher implements EventPublisher {

    protected static final Logger logger = LoggerFactory.getLogger(AbstractEventPublisher.class);

    private EventSender eventSender;

    public AbstractEventPublisher() {
        this.eventSender = createEventSender();
    }

    @Override
    public void publish(Event event) {
        if (event != null) {
            eventSender.send(event);
        } else {
            logger.warn("Cannot post null event");
        }
    }

    protected abstract EventSender createEventSender();

    public EventSender getEventSender() {
        return eventSender;
    }

    public void setEventSender(EventSender eventSender) {
        this.eventSender = eventSender;
    }

}
