/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.event.publisher;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;
import org.json.simple.JSONObject;

public class Event
extends JSONObject {
    private static final long serialVersionUID = 1081109731437677614L;
    public static final String UUID_ENTRY = "uuid";
    public static final String TIMESTAMP_ENTRY = "timestamp";
    public static final String NAME_ENTRY = "name";
    public static final String TYPE_ENTRY = "type";
    public static final String SENDER_ENTRY = "sender";
    public static final String USER_ENTRY = "user";

    public Event(String name, String type, String sender) {
        this(name, type, sender, null);
    }

    public Event(String name, String type, String sender, String user) {
        this(name, type, sender, user, null);
    }

    public Event(String name, String type, String sender, String user, Map<String, String> data) {
        this.setUUID(UUID.randomUUID());
        this.setTimestamp(OffsetDateTime.now());
        this.setName(name);
        this.setType(type);
        this.setSender(sender);
        if (user != null) {
            this.setUser(user);
        }
        if (data != null) {
            this.setAll(data);
        }
    }

    protected void set(String key, String value) {
        this.put(key, value);
    }

    protected void setAll(Map<String, String> entries) {
        this.putAll(entries);
    }

    public void setUUID(UUID uuid) {
        this.set(UUID_ENTRY, uuid.toString());
    }

    public UUID getUUID() {
        return UUID.fromString((String)this.get(UUID_ENTRY));
    }

    public void setTimestamp(OffsetDateTime dateTime) {
        this.set(TIMESTAMP_ENTRY, dateTime.toString());
    }

    public OffsetDateTime getTimestamp() {
        return OffsetDateTime.parse((CharSequence)this.get(TIMESTAMP_ENTRY));
    }

    public void setName(String name) {
        this.set(NAME_ENTRY, name);
    }

    public String getName() {
        return (String)this.get(NAME_ENTRY);
    }

    public void setType(String type) {
        this.set(TYPE_ENTRY, type);
    }

    public String getType() {
        return (String)this.get(TYPE_ENTRY);
    }

    public void setSender(String sender) {
        this.set(SENDER_ENTRY, sender);
    }

    public String getSender() {
        return (String)this.get(SENDER_ENTRY);
    }

    public void setUser(String user) {
        this.set(USER_ENTRY, user);
    }

    public String getUser() {
        return (String)this.get(USER_ENTRY);
    }
}

