/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.event.publisher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.gcube.event.publisher.Event;
import org.gcube.event.publisher.EventSender;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPWithUMAAuthEventSender
implements EventSender {
    protected static final Logger log = LoggerFactory.getLogger(HTTPWithUMAAuthEventSender.class);
    private URL baseEnndpointURL;
    private String clientId;
    private String clientSecret;
    private URL tokenURL;
    private String umaAudience;

    public HTTPWithUMAAuthEventSender(URL baseEnndpointURL, String clientId, String clientSecret, URL tokenURL, String umaAudience) {
        this.baseEnndpointURL = baseEnndpointURL;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenURL = tokenURL;
        this.umaAudience = umaAudience;
    }

    @Override
    public void send(Event event) {
        log.debug("Starting HTTP POST thread to: {}", (Object)this.baseEnndpointURL);
        try {
            URL eventEndpoint = new URL(this.baseEnndpointURL, event.getName());
            new Thread(new HTTPost(eventEndpoint, event)).start();
        }
        catch (MalformedURLException e) {
            log.error("Cannot compute event endpoint URL. Event name: " + event.getName() + ", base endpoint: " + this.baseEnndpointURL, (Throwable)e);
        }
    }

    public class HTTPost
    implements Runnable {
        private static final int CONNECTION_TIMEOUT = 10000;
        private static final int READ_TIMEOUT = 5000;
        private URL endpoint;
        private Event event;

        public HTTPost(URL endpoint, Event event) {
            this.endpoint = endpoint;
            this.event = event;
        }

        @Override
        public void run() {
            try {
                log.debug("Getting OIDC token for client: {}", (Object)HTTPWithUMAAuthEventSender.this.clientId);
                JWTToken umaToken = null;
                if (HTTPWithUMAAuthEventSender.this.clientId != null && HTTPWithUMAAuthEventSender.this.clientSecret != null && HTTPWithUMAAuthEventSender.this.tokenURL != null && HTTPWithUMAAuthEventSender.this.umaAudience != null) {
                    log.debug("Getting OIDC token for clientId '{}' from: {}", (Object)HTTPWithUMAAuthEventSender.this.clientId, (Object)HTTPWithUMAAuthEventSender.this.tokenURL);
                    JWTToken oidcToken = OpenIdConnectRESTHelper.queryClientToken((String)HTTPWithUMAAuthEventSender.this.clientId, (String)HTTPWithUMAAuthEventSender.this.clientSecret, (URL)HTTPWithUMAAuthEventSender.this.tokenURL);
                    log.debug("Getting UMA token for audience '{}' from: {}", (Object)HTTPWithUMAAuthEventSender.this.umaAudience, (Object)HTTPWithUMAAuthEventSender.this.tokenURL);
                    umaToken = OpenIdConnectRESTHelper.queryUMAToken((URL)HTTPWithUMAAuthEventSender.this.tokenURL, (String)oidcToken.getAccessTokenAsBearer(), (String)HTTPWithUMAAuthEventSender.this.umaAudience, null);
                } else {
                    log.debug("Can't get UMA token since not all the required params was provied");
                }
                log.debug("Performing HTTP POST to: {}", (Object)this.endpoint);
                HttpURLConnection connection = (HttpURLConnection)this.endpoint.openConnection();
                connection.setRequestMethod("POST");
                connection.setConnectTimeout(10000);
                log.trace("HTTP connection timeout set to: {}", (Object)connection.getConnectTimeout());
                connection.setReadTimeout(5000);
                log.trace("HTTP connection Read timeout set to: {}", (Object)connection.getReadTimeout());
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                if (umaToken != null) {
                    log.debug("Setting authorization header as: {}", (Object)umaToken.getAccessTokenAsBearer());
                    connection.setRequestProperty("Authorization", umaToken.getAccessTokenAsBearer());
                } else {
                    log.debug("Sending request without authorization header");
                }
                OutputStream os = connection.getOutputStream();
                String jsonString = this.event.toJSONString();
                log.trace("Sending event JSON: {}", (Object)jsonString);
                os.write(jsonString.getBytes("UTF-8"));
                os.flush();
                os.close();
                StringBuilder sb = new StringBuilder();
                int httpResultCode = connection.getResponseCode();
                log.trace("HTTP Response code: {}", (Object)httpResultCode);
                log.trace("Reading response");
                boolean ok = true;
                InputStreamReader isr = null;
                if (httpResultCode == 200) {
                    isr = new InputStreamReader(connection.getInputStream(), "UTF-8");
                } else {
                    ok = false;
                    isr = new InputStreamReader(connection.getErrorStream(), "UTF-8");
                }
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                isr.close();
                if (ok) {
                    log.info("[{}] Event publish for {} is OK", (Object)httpResultCode, (Object)this.event.getName());
                } else {
                    log.debug("[{}] Event publish for {} is not OK", (Object)httpResultCode, (Object)this.event.getName());
                }
                log.trace("Response message from server: {}", (Object)sb.toString());
            }
            catch (Exception e) {
                log.error("POSTing JSON to: " + this.endpoint, (Throwable)e);
            }
        }
    }
}

