/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.event.publisher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.gcube.event.publisher.Event;
import org.gcube.event.publisher.EventSender;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.oidc.rest.OpenIdConnectRESTHelperException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPWithOIDCAuthEventSender
implements EventSender {
    protected static final Logger log = LoggerFactory.getLogger(HTTPWithOIDCAuthEventSender.class);
    private URL baseEndpointURL;
    private String clientId;
    private String clientSecret;
    private URL tokenURL;

    public HTTPWithOIDCAuthEventSender(URL baseEndpointURL, String clientId, String clientSecret, URL tokenURL) {
        this.baseEndpointURL = baseEndpointURL;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenURL = tokenURL;
    }

    @Override
    public void send(Event event) {
        log.debug("Starting HTTP POST thread to: {}", (Object)this.baseEndpointURL);
        new Thread(new HTTPPost(this.baseEndpointURL, event)).start();
    }

    @Override
    public String sendAndGetResult(Event event) {
        log.debug("Starting HTTP POST thread to: {}", (Object)this.baseEndpointURL);
        HTTPPost post = new HTTPPost(this.baseEndpointURL, event);
        Thread postThread = new Thread(post);
        postThread.start();
        try {
            postThread.join();
            return post.getResult();
        }
        catch (InterruptedException e) {
            log.error("While waiting for HTTP Post thread termination", (Throwable)e);
            return null;
        }
    }

    @Override
    public JSONObject retrive(String id) {
        return new HTTPGet(this.baseEndpointURL, id).readJSON();
    }

    protected URL getTokenURL() {
        return this.tokenURL;
    }

    protected JWTToken getAuthorizationToken() throws OpenIdConnectRESTHelperException {
        if (this.clientId != null && this.clientSecret != null && this.tokenURL != null) {
            log.debug("Getting OIDC token for clientId '{}' from: {}", (Object)this.clientId, (Object)this.tokenURL);
            return OpenIdConnectRESTHelper.queryClientToken((String)this.clientId, (String)this.clientSecret, (URL)this.tokenURL);
        }
        log.debug("Can't get OIDC token since not all the required params were provied");
        return null;
    }

    public class HTTPGet
    extends HTTPVerb {
        private String id;

        public HTTPGet(URL baseEndpoint, String id) {
            super(baseEndpoint);
            this.id = id;
        }

        public JSONObject readJSON() {
            URL endpoint = null;
            JSONObject results = null;
            try {
                endpoint = new URL(this.baseEndpoint, this.id);
            }
            catch (MalformedURLException e) {
                log.error("Cannot compute retrieve endpoint URL. ID: " + this.id + ", base endpoint: " + HTTPWithOIDCAuthEventSender.this.baseEndpointURL, (Throwable)e);
                return null;
            }
            try {
                log.debug("Getting auth token for client '{}' if needed", (Object)HTTPWithOIDCAuthEventSender.this.clientId);
                JWTToken token = HTTPWithOIDCAuthEventSender.this.getAuthorizationToken();
                log.debug("Performing HTTP GET to: {}", (Object)endpoint);
                HttpURLConnection connection = (HttpURLConnection)endpoint.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(10000);
                log.trace("HTTP connection timeout set to: {}", (Object)connection.getConnectTimeout());
                connection.setReadTimeout(5000);
                log.trace("HTTP connection Read timeout set to: {}", (Object)connection.getReadTimeout());
                if (token != null) {
                    log.debug("Setting authorization header as: {}", (Object)token.getAccessTokenAsBearer());
                    connection.setRequestProperty("Authorization", token.getAccessTokenAsBearer());
                } else {
                    log.debug("Sending request without authorization header");
                }
                StringBuilder sb = new StringBuilder();
                int httpResultCode = connection.getResponseCode();
                log.trace("HTTP Response code: {}", (Object)httpResultCode);
                log.trace("Reading response");
                InputStreamReader isr = null;
                isr = httpResultCode == 200 ? new InputStreamReader(connection.getInputStream(), "UTF-8") : new InputStreamReader(connection.getErrorStream(), "UTF-8");
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                isr.close();
                if (httpResultCode == 200) {
                    log.debug("[{}] Got results for {}", (Object)httpResultCode, (Object)this.id);
                    try {
                        results = (JSONObject)new JSONParser().parse(sb.toString());
                    }
                    catch (ParseException e) {
                        log.warn("Error parsing results string as JSON: {}", (Object)sb.toString());
                    }
                } else {
                    log.warn("[{}] Error getting results for ID {}", (Object)httpResultCode, (Object)this.id);
                }
            }
            catch (IOException | OpenIdConnectRESTHelperException e) {
                log.error("Getting results from: " + endpoint, e);
            }
            return results;
        }
    }

    public class HTTPPost
    extends HTTPVerb
    implements Runnable {
        private static final int PAUSE_INCREMENT_FACTOR = 2;
        private static final long MAX_RETRYINGS = 2L;
        private final int[] RETRY_CODES;
        private Event event;
        private String result;
        private long actualPause;
        private long retryings;

        public HTTPPost(URL baseEndpoint, Event event) {
            super(baseEndpoint);
            this.RETRY_CODES = new int[]{502, 408, 504, 500};
            this.actualPause = 1L;
            this.retryings = 0L;
            this.event = event;
        }

        @Override
        public void run() {
            try {
                URL eventEndpoint = null;
                try {
                    eventEndpoint = new URL(HTTPWithOIDCAuthEventSender.this.baseEndpointURL, this.event.getName());
                }
                catch (MalformedURLException e) {
                    log.error("Cannot compute event endpoint URL. Event name: " + this.event.getName() + ", base endpoint: " + HTTPWithOIDCAuthEventSender.this.baseEndpointURL, (Throwable)e);
                    return;
                }
                boolean OK = false;
                do {
                    try {
                        log.debug("Getting auth token for client '{}' if needed", (Object)HTTPWithOIDCAuthEventSender.this.clientId);
                        JWTToken token = HTTPWithOIDCAuthEventSender.this.getAuthorizationToken();
                        log.debug("Performing HTTP POST to: {}", (Object)this.baseEndpoint);
                        HttpURLConnection connection = (HttpURLConnection)eventEndpoint.openConnection();
                        connection.setRequestMethod("POST");
                        connection.setConnectTimeout(10000);
                        log.trace("HTTP connection timeout set to: {}", (Object)connection.getConnectTimeout());
                        connection.setReadTimeout(5000);
                        log.trace("HTTP connection Read timeout set to: {}", (Object)connection.getReadTimeout());
                        connection.setRequestProperty("Content-Type", "application/json");
                        connection.setDoOutput(true);
                        if (token != null) {
                            log.debug("Setting authorization header as: {}", (Object)token.getAccessTokenAsBearer());
                            connection.setRequestProperty("Authorization", token.getAccessTokenAsBearer());
                        } else {
                            log.debug("Sending request without authorization header");
                        }
                        OutputStream os = connection.getOutputStream();
                        String jsonString = this.event.toJSONString();
                        log.trace("Sending event JSON: {}", (Object)jsonString);
                        os.write(jsonString.getBytes("UTF-8"));
                        os.flush();
                        os.close();
                        StringBuilder sb = new StringBuilder();
                        int httpResultCode = connection.getResponseCode();
                        log.trace("HTTP Response code: {}", (Object)httpResultCode);
                        log.trace("Reading response");
                        InputStreamReader isr = null;
                        if (httpResultCode == 200) {
                            OK = true;
                            isr = new InputStreamReader(connection.getInputStream(), "UTF-8");
                        } else {
                            isr = new InputStreamReader(connection.getErrorStream(), "UTF-8");
                        }
                        BufferedReader br = new BufferedReader(isr);
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            sb.append("\n" + line);
                        }
                        br.close();
                        isr.close();
                        sb.deleteCharAt(0);
                        this.result = sb.toString();
                        if (OK) {
                            log.debug("[{}] Event publish for {} is OK", (Object)httpResultCode, (Object)this.event.getName());
                            continue;
                        }
                        log.trace("Response message from server:\n{}", (Object)this.result);
                        if (this.shouldRetryWithCode(httpResultCode)) {
                            if (this.retryings <= 2L) {
                                log.warn("[{}] Event publish ERROR, retrying in {} seconds", (Object)httpResultCode, (Object)this.actualPause);
                                Thread.sleep(this.actualPause * 1000L);
                                log.debug("Start retrying event publish: {}", (Object)this.event.getName());
                                this.actualPause *= 2L;
                                ++this.retryings;
                                continue;
                            }
                            log.error("[{}] Event publish ERROR, exhausted tries after {} retryings", (Object)httpResultCode, (Object)this.retryings);
                        } else {
                            log.info("[{}] Event publish ERROR but should not retry with this HTTP code", (Object)httpResultCode);
                        }
                        break;
                    }
                    catch (IOException | OpenIdConnectRESTHelperException e) {
                        log.error("POSTing JSON to: " + eventEndpoint, e);
                    }
                } while (!OK);
            }
            catch (InterruptedException e) {
                log.error("Sleeping before retry event send", (Throwable)e);
            }
        }

        private boolean shouldRetryWithCode(int httpResultCode) {
            return Arrays.binarySearch(this.RETRY_CODES, httpResultCode) > 0;
        }

        public String getResult() {
            return this.result;
        }
    }

    public abstract class HTTPVerb {
        protected static final int CONNECTION_TIMEOUT = 10000;
        protected static final int READ_TIMEOUT = 5000;
        protected URL baseEndpoint;

        public HTTPVerb(URL baseEndpoint) {
            this.baseEndpoint = baseEndpoint;
        }
    }
}

