/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.event.publisher;

import org.gcube.event.publisher.EventStatus;
import org.gcube.event.publisher.ResultsParser;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConductorResultsParser
implements ResultsParser {
    protected static final Logger logger = LoggerFactory.getLogger(ConductorResultsParser.class);

    @Override
    public EventStatus parseResults(String uuid, JSONObject results) {
        EventStatus eventStatus = null;
        if (results != null) {
            JSONObject input = (JSONObject)results.get((Object)"input");
            JSONObject output = (JSONObject)results.get((Object)"output");
            switch ((String)results.get((Object)"status")) {
                case "COMPLETED": {
                    eventStatus = EventStatus.COMPLETED(uuid, input, output);
                    break;
                }
                case "FAILED": {
                    eventStatus = EventStatus.FAILED(uuid, input, output);
                    break;
                }
                case "NOT_FOUND": {
                    eventStatus = EventStatus.NOT_FOUND(uuid);
                    break;
                }
                case "PAUSED": {
                    eventStatus = EventStatus.PAUSED(uuid, input);
                    break;
                }
                case "RUNNING": {
                    eventStatus = EventStatus.RUNNING(uuid, input);
                    break;
                }
                case "TERMINATED": {
                    eventStatus = EventStatus.TERMINATED(uuid, input, output);
                    break;
                }
                default: {
                    eventStatus = EventStatus.NOT_FOUND(uuid);
                    break;
                }
            }
        } else {
            logger.warn("Nothing to parse since JSON object is null");
        }
        return eventStatus;
    }
}

