/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.gcube.io.jsonwebtoken.Claims;
import org.gcube.io.jsonwebtoken.CompressionCodec;
import org.gcube.io.jsonwebtoken.Jwts;
import org.gcube.io.jsonwebtoken.impl.io.Streams;
import org.gcube.io.jsonwebtoken.impl.lang.Bytes;
import org.gcube.io.jsonwebtoken.io.CompressionAlgorithm;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.lang.Strings;

class Payload {
    static final Payload EMPTY = new Payload(Bytes.EMPTY, null);
    private final CharSequence string;
    private final byte[] bytes;
    private final Claims claims;
    private final InputStream inputStream;
    private final boolean inputStreamEmpty;
    private final String contentType;
    private CompressionAlgorithm zip;
    private boolean claimsExpected;

    Payload(Claims claims) {
        this(claims, null, null, null, null);
    }

    Payload(CharSequence content, String contentType) {
        this(null, content, null, null, contentType);
    }

    Payload(byte[] content, String contentType) {
        this(null, null, content, null, contentType);
    }

    Payload(InputStream inputStream, String contentType) {
        this(null, null, null, inputStream, contentType);
    }

    private Payload(Claims claims, CharSequence string, byte[] bytes, InputStream inputStream, String contentType) {
        this.claims = claims;
        this.string = Strings.clean((CharSequence)string);
        this.contentType = Strings.clean((String)contentType);
        InputStream in = inputStream;
        byte[] data = Bytes.nullSafe(bytes);
        if (Strings.hasText((CharSequence)this.string)) {
            data = Strings.utf8((CharSequence)this.string);
        }
        this.bytes = data;
        if (in == null && !Bytes.isEmpty(this.bytes)) {
            in = Streams.of(data);
        }
        this.inputStreamEmpty = in == null;
        this.inputStream = this.inputStreamEmpty ? Streams.of(Bytes.EMPTY) : in;
    }

    boolean isClaims() {
        return !Collections.isEmpty((Map)this.claims);
    }

    Claims getRequiredClaims() {
        return (Claims)Assert.notEmpty((Map)this.claims, (String)"Claims cannot be null or empty when calling this method.");
    }

    boolean isString() {
        return Strings.hasText((CharSequence)this.string);
    }

    String getContentType() {
        return this.contentType;
    }

    public void setZip(CompressionAlgorithm zip) {
        this.zip = zip;
    }

    boolean isCompressed() {
        return this.zip != null;
    }

    public void setClaimsExpected(boolean claimsExpected) {
        this.claimsExpected = claimsExpected;
    }

    boolean isConsumable() {
        return !this.isClaims() && (this.isString() || !Bytes.isEmpty(this.bytes) || this.inputStream != null && this.claimsExpected);
    }

    boolean isEmpty() {
        return !this.isClaims() && !this.isString() && Bytes.isEmpty(this.bytes) && this.inputStreamEmpty;
    }

    public OutputStream compress(OutputStream out) {
        return this.zip != null ? this.zip.compress(out) : out;
    }

    public Payload decompress(CompressionAlgorithm alg) {
        Assert.notNull((Object)alg, (String)"CompressionAlgorithm cannot be null.");
        Payload payload = this;
        if (!this.isString() && this.isConsumable()) {
            if (alg.equals(Jwts.ZIP.DEF) && !Bytes.isEmpty(this.bytes)) {
                byte[] data = ((CompressionCodec)alg).decompress(this.bytes);
                payload = new Payload(this.claims, this.string, data, null, this.getContentType());
            } else {
                InputStream in = this.toInputStream();
                in = alg.decompress(in);
                payload = new Payload(this.claims, this.string, this.bytes, in, this.getContentType());
            }
            payload.setClaimsExpected(this.claimsExpected);
        }
        return payload;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    InputStream toInputStream() {
        Assert.state((!this.isClaims() ? 1 : 0) != 0, (String)"Claims exist, cannot convert to InputStream directly.");
        return this.inputStream;
    }
}

