package org.gcube.common.geoserverinterface.engine;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeStyle {
	
	private static final Logger logger = LoggerFactory.getLogger(MakeStyle.class);
	
	
	
	// docs start create style
	/**
	 * Create a rendering style to display features from the given feature source by matching unique values of the specified feature attribute to colours
	 * 
	 * @param reader
	 *            the feature source
	 * @return a new Style instance
	 * @throws Exception
	 */

	public class ClassStyleDef {
		public ClassStyleDef() {
			super();
			// TODO Auto-generated constructor stub
		}

		/**
		 * @uml.property name="from"
		 */
		Object from = 0;
		/**
		 * @uml.property name="to"
		 */
		Object to = 0;

		public ClassStyleDef(Object from, Object to) {
			super();
			this.from = from;
			this.to = to;
		}

		/**
		 * @return
		 * @uml.property name="from"
		 */
		public Object getFrom() {
			return from;
		}

		/**
		 * @return
		 * @uml.property name="to"
		 */
		public Object getTo() {
			return to;
		}

		/**
		 * @param from
		 * @uml.property name="from"
		 */
		public void setFrom(Object from) {
			this.from = from;
		}

		/**
		 * @param to
		 * @uml.property name="to"
		 */
		public void setTo(Object to) {
			this.to = to;
		}
	}

	public static String createStyle(String nameStyle, String attributeName, ArrayList<ClassStyleDef> classes, Color c1, Color c2) throws Exception {

		int nClasses = classes.size();

		if (nClasses <= 0)
			throw new Exception("Invalid number of classes!!");

		int nColors = nClasses;
		StyleBuilder sb = new StyleBuilder();
		Style style = sb.createStyle();

		style.setName(nameStyle);

		ArrayList<Rule> rules = new ArrayList<Rule>();

		// System.out.println("iMin " + min + " iMax " + max + " d " + d + " nColors " + nColors);

		ArrayList<Color> colors = gradientColor(nColors, c1, c2);

		int color = 0;
		for (ClassStyleDef cls : classes) {

			rules.add(addRule(sb, attributeName, cls.getTo(), cls.getFrom(), colors.get(color)));

			color++;
		}

		FeatureTypeStyle fts = sb.createFeatureTypeStyle("Feature", rules.toArray(new Rule[rules.size()]));

		style.featureTypeStyles().add(fts);

		SLDTransformer aTransformer = new SLDTransformer();
		aTransformer.setIndentation(4);

		return aTransformer.transform(style);
	}

	public static String createStyle(String nameStyle, String attributeName, int nClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue) throws Exception {

		if (nClasses <= 0)
			throw new Exception("Invalid number of classes!!");

		Double fMax = Double.valueOf(0.0f);
		Double fMin = Double.valueOf(0.0);

		// System.out.println("---go");

		if (maxValue instanceof Integer)
			fMax = (Integer) maxValue * Double.valueOf(1.0);
		if (minValue instanceof Integer)
			fMin = (Integer) minValue * Double.valueOf(1.0);
		if (maxValue instanceof Float)
			fMax = ((Float) maxValue).doubleValue();
		if (minValue instanceof Float)
			fMin = ((Float) minValue).doubleValue();
		if (maxValue instanceof Double)
			fMax = (double) ((Double) maxValue * Double.valueOf(1.0));
		if (minValue instanceof Double)
			fMin = (double) ((Double) minValue * Double.valueOf(1.0));
		if (maxValue instanceof String)
			fMax = Double.parseDouble((String) maxValue);
		if (minValue instanceof String)
			fMin = Double.parseDouble((String) minValue);

		// System.out.println("---max "+fMax+" min "+fMin);

		if (fMax.compareTo(fMin) < 0)
			throw new Exception("The maximum value must be greater than the minimum value!!");

		// System.out.println("---build style");

		StyleBuilder sb = new StyleBuilder();
		// System.out.println("---create style");
		Style style = sb.createStyle();
		// System.out.println("---set name");
		style.setName(nameStyle);

		ArrayList<Rule> rules = new ArrayList<Rule>();
		if (typeValue == Integer.class) {
			// System.out.println("---Int management");
			Integer iMin = fMin.intValue();
			Integer iMax = fMax.intValue();
			Integer d = ((iMax + 1) - iMin) / nClasses;

			if (d == 0)
				throw new Exception("Too many classes with these values!!");

			Integer start = iMin;

			int nColors = getColorsNumbers(start, iMax, d);
			ArrayList<Color> colors = gradientColor(nColors, c1, c2);

			if (d == 1) {
				int color = 0;
				while (start <= iMax) {
					rules.add(addRule(sb, attributeName, start, colors.get(color)));
					start = start + d;
					color++;
				}

			} else {
				int color = 0;
				while (start <= iMax) {
					// System.out.println("from start " + start + " to " + (start + d));

					if (start == iMax)
						rules.add(addRule(sb, attributeName, start, colors.get(color)));
					else
						rules.add(addRule(sb, attributeName, start + d, start, colors.get(color)));
					start = start + d;
					color++;
				}
			}
		} else {

			logger.debug("---Doubles: " + fMax + " - " + fMin);

			float floatMax = fMax.floatValue();
			if (floatMax > fMax)
				fMax = (double) floatMax;

			float floatMin = fMin.floatValue();
			if (floatMin < fMin)
				fMin = (double) floatMin;

			logger.debug("---Floats: " + floatMax + " - " + floatMin);
			fMax = (double) Math.ceil(fMax * 100) / (double) 100;
			fMin = (double) Math.floor(fMin * 100) / (double) 100;

			logger.debug("---RE-Doubles: " + fMax + " - " + fMin);

			Double d = (fMax - fMin) / nClasses;

			d = (double) Math.floor(d * 100) / (double) 100;

			// if ((d<1f)&&(d!=0.0f)) d = 1f;

			// System.out.println("---d "+d);
			// System.out.println("iMin " + min + " iMax " + max + " d " + d + " nColors " + nColors);

			if (d == 0)
				throw new Exception("Too many classes with these values!!");

			Double start = fMin;

			int nColors = getColorsNumbers(start, fMax, d);

			ArrayList<Color> colors = gradientColor(nColors, c1, c2);

			// System.out.println("---d: "+d+" ncolors "+nColors+" c1:"+c1+" c2:"+c2);

			if (d == 1) {
				int color = 0;
				logger.debug("---d==1");
				while (start.compareTo(fMax) <= 0) {
					// System.out.println("---start: "+start);
					// System.out.println("---adding rule");
					rules.add(addRule(sb, attributeName, start, colors.get(color)));
					// System.out.println("---added rule");
					start = start + d;
					color++;
				}

			} else {
				logger.debug("---d!=1");
				int color = 0;
				while (start.compareTo(fMax) <= 0) {
					// System.out.println("from start " + start + " to " + (start + d));
					// System.out.println("---start: "+start);

					if (start.compareTo(fMax) == 0) {
						// System.out.println("---adding rule");
						rules.add(addRule(sb, attributeName, start, colors.get(color)));
					} else {
						// System.out.println("---adding other rule");
						rules.add(addRule(sb, attributeName, start + d, start, colors.get(color)));
					}

					start = start + d;
					color++;
				}
			}
		}
		// System.out.println("---adding features");
		FeatureTypeStyle fts = sb.createFeatureTypeStyle("Feature", rules.toArray(new Rule[rules.size()]));
		// System.out.println("---adding style feature");
		style.featureTypeStyles().add(fts);
		// System.out.println("---adding transformer");
		SLDTransformer aTransformer = new SLDTransformer();
		aTransformer.setIndentation(4);
		// System.out.println("---adding transformer to style");
		String out = aTransformer.transform(style);
		logger.debug("---done!");
		return out;
	}

	public static String createStyleScatterColors(String nameStyle, String attributeName, int nClasses,Class typeValue, Object maxValue, Object minValue) throws Exception {

		if (nClasses <= 0)
			throw new Exception("Invalid number of classes!!");
		Double fMax = Double.valueOf(0.0f);
		Double fMin = Double.valueOf(0.0);
		if (maxValue instanceof Integer)
			fMax = (Integer) maxValue * Double.valueOf(1.0);
		if (minValue instanceof Integer)
			fMin = (Integer) minValue * Double.valueOf(1.0);
		if (maxValue instanceof Float)
			fMax = ((Float) maxValue).doubleValue();
		if (minValue instanceof Float)
			fMin = ((Float) minValue).doubleValue();
		if (maxValue instanceof Double)
			fMax = (double) ((Double) maxValue * Double.valueOf(1.0));
		if (minValue instanceof Double)
			fMin = (double) ((Double) minValue * Double.valueOf(1.0));
		if (maxValue instanceof String)
			fMax = Double.parseDouble((String) maxValue);
		if (minValue instanceof String)
			fMin = Double.parseDouble((String) minValue);
		if (fMax.compareTo(fMin) < 0)
			throw new Exception("The maximum value must be greater than the minimum value!!");

		StyleBuilder sb = new StyleBuilder();
		Style style = sb.createStyle();
		style.setName(nameStyle);

		ArrayList<Rule> rules = new ArrayList<Rule>();
		if (typeValue == Integer.class) {
			Integer iMin = fMin.intValue();
			Integer iMax = fMax.intValue();
			Integer d = ((iMax + 1) - iMin) / nClasses;
			if (d == 0)
				throw new Exception("Too many classes with these values!!");
			Integer start = iMin;
			int nColors = getColorsNumbers(start, iMax, d);
			ArrayList<Color> colors = scatterColor(nColors);
			if (d == 1) {
				int color = 0;
				while (start <= iMax) {
					rules.add(addRule(sb, attributeName, start, colors.get(color)));
					start = start + d;
					color++;
				}
			} else {
				int color = 0;
				while (start <= iMax) {
					if (start == iMax)
						rules.add(addRule(sb, attributeName, start, colors.get(color)));
					else
						rules.add(addRule(sb, attributeName, start + d, start, colors.get(color)));
					start = start + d;
					color++;
				}
			}
		} else {
			logger.debug("---Doubles: " + fMax + " - " + fMin);
			float floatMax = fMax.floatValue();
			if (floatMax > fMax)
				fMax = (double) floatMax;
			float floatMin = fMin.floatValue();
			if (floatMin < fMin)
				fMin = (double) floatMin;
			logger.debug("---Floats: " + floatMax + " - " + floatMin);
			fMax = (double) Math.ceil(fMax * 100) / (double) 100;
			fMin = (double) Math.floor(fMin * 100) / (double) 100;
			logger.debug("---RE-Doubles: " + fMax + " - " + fMin);
			Double d = (fMax - fMin) / nClasses;
			d = (double) Math.floor(d * 100) / (double) 100;
			if (d == 0)
				throw new Exception("Too many classes with these values!!");
			Double start = fMin;
			int nColors = getColorsNumbers(start, fMax, d);
			ArrayList<Color> colors = scatterColor(nColors);
			if (d == 1) {
				int color = 0;
				logger.debug("---d==1");
				while (start.compareTo(fMax) <= 0) {
					rules.add(addRule(sb, attributeName, start, colors.get(color)));
					start = start + d;
					color++;
				}
			} else {
				logger.debug("---d!=1");
				int color = 0;
				while (start.compareTo(fMax) <= 0) {
					if (start.compareTo(fMax) == 0) {
						rules.add(addRule(sb, attributeName, start, colors.get(color)));
					} else {
						rules.add(addRule(sb, attributeName, start + d, start, colors.get(color)));
					}
					start = start + d;
					color++;
				}
			}
		}
		FeatureTypeStyle fts = sb.createFeatureTypeStyle("Feature", rules.toArray(new Rule[rules.size()]));
		style.featureTypeStyles().add(fts);
		SLDTransformer aTransformer = new SLDTransformer();
		aTransformer.setIndentation(4);
		String out = aTransformer.transform(style);
		logger.debug("---done!");
		return out;
	}

	public static String createStyleLog(String nameStyle, String attributeName, int nClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue) throws Exception {

		if (nClasses <= 0)
			throw new Exception("Invalid number of classes!!");

		Float fMax = 0.0f;
		Float fMin = 0.0f;

		if (maxValue instanceof Integer)
			fMax = (Integer) maxValue * 1.0f;
		if (minValue instanceof Integer)
			fMin = (Integer) minValue * 1.0f;
		if (maxValue instanceof Float)
			fMax = (Float) maxValue;
		if (minValue instanceof Float)
			fMin = (Float) minValue;
		if (maxValue instanceof Double)
			fMax = (float) ((Double) maxValue * 1.0f);
		if (minValue instanceof Double)
			fMin = (float) ((Double) minValue * 1.0f);
		if (maxValue instanceof String)
			fMax = Float.parseFloat((String) maxValue);
		if (minValue instanceof String)
			fMin = Float.parseFloat((String) minValue);

		if (fMax.compareTo(fMin) < 0)
			throw new Exception("The maximum value must be greater than the minimum value!!");

		StyleBuilder sb = new StyleBuilder();
		Style style = sb.createStyle();

		style.setName(nameStyle);

		Double[] intervals;
		ArrayList<Rule> rules = new ArrayList<Rule>();
		if (typeValue == Integer.class) {
			Integer iMin = fMin.intValue();
			Integer iMax = fMax.intValue();

			int startLog = (iMin <= 0 ? 1 : iMin);

			intervals = logSubdivision(startLog, iMax, nClasses);

			ArrayList<Color> colors = gradientColor(intervals.length, c1, c2);
			int color = 0;

			if (intervals.length <= 0) {
				throw new Exception("Invalid interval!!");
			} else if (intervals.length == 1) {
				intervals[0] = iMin * 1.0;
				rules.add(addRule(sb, attributeName, intervals[0].intValue(), colors.get(color)));
			} else {
				intervals[0] = iMin * 1.0;
				for (int i = 0; i < intervals.length - 1; i++) {
					rules.add(addRule(sb, attributeName, intervals[i + 1].intValue(), intervals[i].intValue(), colors.get(color)));
					color++;
				}
			}
		} else {
			float startLog = (fMin <= 0 ? 1.0f : fMin);

			intervals = logSubdivision(startLog, fMax, nClasses);

			ArrayList<Color> colors = gradientColor(intervals.length, c1, c2);
			int color = 0;

			if (intervals.length <= 0) {
				throw new Exception("Invalid interval!!");
			} else if (intervals.length == 1) {
				intervals[0] = fMin * 1.0;
				rules.add(addRule(sb, attributeName, round(intervals[0], 3), colors.get(color)));
			} else {
				intervals[0] = fMin * 1.0;
				for (int i = 0; i < intervals.length - 1; i++) {
					rules.add(addRule(sb, attributeName, round(intervals[i + 1], 3), round(intervals[i], 3), colors.get(color)));
					color++;
				}
			}
		}

		FeatureTypeStyle fts = sb.createFeatureTypeStyle("Feature", rules.toArray(new Rule[rules.size()]));

		style.featureTypeStyles().add(fts);

		SLDTransformer aTransformer = new SLDTransformer();
		aTransformer.setIndentation(4);

		return aTransformer.transform(style);
	}

	private static Double[] logSubdivision(double start, double end, int numberOfParts) {

		if (end <= start)
			return null;

		double logStart = Math.log(start);
		double logEnd = Math.log(end);
		double difference = logEnd - logStart;
		double step = 0;
		if (numberOfParts > 0)
			step = (difference / (double) numberOfParts);
		// double [] points = new double[numberOfParts+1];
		Double[] linearpoints = new Double[numberOfParts + 1];

		for (int i = 0; i < numberOfParts + 1; i++) {

			// points[i] = logStart+(i*step);

			linearpoints[i] = Math.exp(logStart + (i * step));
			if (linearpoints[i] < 0.011)
				linearpoints[i] = 0.0;
		}

		return linearpoints;
	}

	private static int getColorsNumbers(Integer start, Integer iMax, Integer d) {
		int color = 0;
		while (start <= iMax) {
			start = start + d;
			color++;
		}
		return color;
	}

	private static int getColorsNumbers(Double start, Double fMax, Double d) {
		int color = 0;
		// System.out.println("--start:"+start+" fmax "+fMax);
		int i = 0;
		while (start <= fMax) {
			// System.out.println("--start:"+start+" fmax "+fMax+" d "+d);
			double s = start + d;
			// System.out.println("--s:"+s);
			start = s;
			color++;
			i++;
			// System.out.println("i "+i);
			if (i > 50)
				break;
		}
		// System.out.println("--COLORED");
		return color;
	}

	private static Rule addRule(StyleBuilder sb, String attributeName, Object lessThe, Object greater, Color fillColor) {

		Symbolizer polygonSymbolizer = sb.createPolygonSymbolizer(fillColor);

		Rule rule = sb.createRule(polygonSymbolizer);

		if ((greater instanceof Double) || (greater instanceof Float))
			greater = roundDecimal(((Number) greater).doubleValue(), 2);
		if ((lessThe instanceof Double) || (lessThe instanceof Float))
			lessThe = roundDecimal(((Number) lessThe).doubleValue(), 2);

		rule.setTitle(">= " + greater + " - < " + lessThe);
		FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);

//		Filter filterThen = filterFactory.greaterOrEqual(filterFactory.property(attributeName), filterFactory.literal(greater), true);
		Filter filterThen = filterFactory.greaterOrEqual(filterFactory.property(attributeName), filterFactory.literal(greater));
		Filter filterElse = filterFactory.less(filterFactory.property(attributeName), filterFactory.literal(lessThe));

		Filter filter = filterFactory.and(filterThen, filterElse);

		rule.setFilter(filter);

		return rule;
	}

	private static Rule addRule(StyleBuilder sb, String attributeName, Object equal, Color fillColor) {

		Symbolizer polygonSymbolizer = sb.createPolygonSymbolizer(fillColor);

		Rule rule = sb.createRule(polygonSymbolizer);

		if (equal instanceof Double)
			equal = roundDecimal((Double) equal, 2);

		rule.setTitle("=" + equal);
		FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
//		Filter filter = filterFactory.equal(filterFactory.property(attributeName), filterFactory.literal(equal), true);
		Filter filter = filterFactory.equal(filterFactory.property(attributeName), filterFactory.literal(equal));
		rule.setFilter(filter);

		return rule;
	}

	private static ArrayList<Color> gradientColor(int nColors, Color c1, Color c2) {
		// a linear gradient.
		ArrayList<Color> colors = new ArrayList<Color>();
		for (int i = 0; i < nColors; i++) {
			float ratio = (float) i / (float) nColors;
			int red = (int) (c2.getRed() * ratio + c1.getRed() * (1 - ratio));
			int green = (int) (c2.getGreen() * ratio + c1.getGreen() * (1 - ratio));
			int blue = (int) (c2.getBlue() * ratio + c1.getBlue() * (1 - ratio));
			colors.add(new Color(red, green, blue));
		}

		return colors;
	}

	public static ArrayList<Color> scatterColor(int nColors) {

		ArrayList<Color> colors = new ArrayList<Color>();
		float saturation = 1;
		float brightness = 1;
		for (int i = 0; i < nColors; i++) {
			float ratio = (((float) i)*1.5f) / (float) nColors;
			if (i%10==0)
				brightness = (float) Math.max(0.1,brightness-0.1);
//			else
//				saturation = (float) Math.max(0.1,saturation-0.1);
			
//			System.out.println("ratio degrees "+ratio);
			int rgb = Color.HSBtoRGB(ratio, brightness, saturation);
			Color color = new Color(rgb);
			colors.add(color);
		}

		return colors;
	}

	public static int HexToR(String h) {

		return Integer.parseInt(cutHex(h).substring(0, 2), 16);
	}

	public static int HexToG(String h) {

		return Integer.parseInt(cutHex(h).substring(2, 4), 16);
	}

	public static int HexToB(String h) {

		return Integer.parseInt(cutHex(h).substring(4, 6), 16);
	}

	public static String cutHex(String h) {

		return h.substring(0, 1).contentEquals("#") ? h.substring(1) : h;
	}

	public static double round(double d, int decimalPlace) {
		BigDecimal bd = new BigDecimal(Double.toString(d));
		bd = bd.setScale(decimalPlace, BigDecimal.ROUND_HALF_UP);
		return bd.doubleValue();
	}

	// rounds to the xth decimal position
	public static double roundDecimal(double number, int decimalposition) {

		double n = (double) Math.round(number * Math.pow(10.00, decimalposition)) / Math.pow(10.00, decimalposition);
		return n;
	}
}