/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.bean.iso;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.geoserverinterface.Constants;
import org.gcube.common.geoserverinterface.bean.iso.Thesaurus;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="EnvironmentConfiguration")
public class EnvironmentConfiguration
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentConfiguration.class);
    private static EnvironmentConfiguration current = null;
    private static long lastUpdate = 0L;
    private static TransformerFactory tf = TransformerFactory.newInstance();
    private static Transformer transformer;
    private static XStream xstream;
    private String wmsProtocolDeclaration;
    private String wfsProtocolDeclaration;
    private String wcsProtocolDeclaration;
    private String httpProtocolDeclaration;
    private String defaultCRS;
    private String projectName;
    private String projectCitation;
    private String distributorIndividualName;
    private String distributorOrganisationName;
    private String distributorEMail;
    private String distributorSite;
    private String providerIndividualName;
    private String providerOrganisationName;
    private String providerEMail;
    private String providerSite;
    private String license;
    private HashMap<String, Thesaurus> thesauri = new HashMap();

    static {
        xstream = new XStream();
        try {
            transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
        }
        catch (Exception e) {
            logger.error("Unable to initialize transformer ", (Throwable)e);
        }
        xstream.processAnnotations(EnvironmentConfiguration.class);
        xstream.processAnnotations(Thesaurus.class);
    }

    public static synchronized EnvironmentConfiguration getConfiguration() throws Exception {
        if (System.currentTimeMillis() - lastUpdate > Constants.getMetadataConfigurationTimeToLive()) {
            current = EnvironmentConfiguration.getFromIS();
        }
        return current;
    }

    private static EnvironmentConfiguration getFromIS() throws Exception {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq '" + Constants.getGenericResourceSecondaryType() + "'").addCondition("$resource/Profile/Name/text() eq '" + Constants.getGenericResourceName() + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        for (GenericResource resource : client.submit((Query)query)) {
            try {
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(resource.profile().body()), new StreamResult(writer));
                String theXML = writer.getBuffer().toString();
                EnvironmentConfiguration config = (EnvironmentConfiguration)xstream.fromXML(theXML.substring(5, theXML.length() - 6));
                return config;
            }
            catch (Exception e) {
                logger.warn("Unable to parse resource [ID :" + resource.id() + "]", (Throwable)e);
            }
        }
        throw new Exception("No Configuration Found");
    }

    public String getWmsProtocolDeclaration() {
        return this.wmsProtocolDeclaration;
    }

    public void setWmsProtocolDeclaration(String wmsProtocolDeclaration) {
        this.wmsProtocolDeclaration = wmsProtocolDeclaration;
    }

    public String getWfsProtocolDeclaration() {
        return this.wfsProtocolDeclaration;
    }

    public void setWfsProtocolDeclaration(String wfsProtocolDeclaration) {
        this.wfsProtocolDeclaration = wfsProtocolDeclaration;
    }

    public String getWcsProtocolDeclaration() {
        return this.wcsProtocolDeclaration;
    }

    public void setWcsProtocolDeclaration(String wcsProtocolDeclaration) {
        this.wcsProtocolDeclaration = wcsProtocolDeclaration;
    }

    public String getHttpProtocolDeclaration() {
        return this.httpProtocolDeclaration;
    }

    public void setHttpProtocolDeclaration(String httpProtocolDeclaration) {
        this.httpProtocolDeclaration = httpProtocolDeclaration;
    }

    public String getDefaultCRS() {
        return this.defaultCRS;
    }

    public void setDefaultCRS(String defaultCRS) {
        this.defaultCRS = defaultCRS;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCitation() {
        return this.projectCitation;
    }

    public void setProjectCitation(String projectCitation) {
        this.projectCitation = projectCitation;
    }

    public String getDistributorIndividualName() {
        return this.distributorIndividualName;
    }

    public void setDistributorIndividualName(String distributorIndividualName) {
        this.distributorIndividualName = distributorIndividualName;
    }

    public String getDistributorOrganisationName() {
        return this.distributorOrganisationName;
    }

    public void setDistributorOrganisationName(String distributorOrganisationName) {
        this.distributorOrganisationName = distributorOrganisationName;
    }

    public String getDistributorEMail() {
        return this.distributorEMail;
    }

    public void setDistributorEMail(String distributorEMail) {
        this.distributorEMail = distributorEMail;
    }

    public String getDistributorSite() {
        return this.distributorSite;
    }

    public void setDistributorSite(String distributorSite) {
        this.distributorSite = distributorSite;
    }

    public String getProviderIndividualName() {
        return this.providerIndividualName;
    }

    public void setProviderIndividualName(String providerIndividualName) {
        this.providerIndividualName = providerIndividualName;
    }

    public String getProviderOrganisationName() {
        return this.providerOrganisationName;
    }

    public void setProviderOrganisationName(String providerOrganisationName) {
        this.providerOrganisationName = providerOrganisationName;
    }

    public String getProviderEMail() {
        return this.providerEMail;
    }

    public void setProviderEMail(String providerEMail) {
        this.providerEMail = providerEMail;
    }

    public String getProviderSite() {
        return this.providerSite;
    }

    public void setProviderSite(String providerSite) {
        this.providerSite = providerSite;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public HashMap<String, Thesaurus> getThesauri() {
        return this.thesauri;
    }

    public void setThesauri(HashMap<String, Thesaurus> thesauri) {
        this.thesauri = thesauri;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EnvironmentConfiguration [wmsProtocolDeclaration=");
        builder.append(this.wmsProtocolDeclaration);
        builder.append(", wfsProtocolDeclaration=");
        builder.append(this.wfsProtocolDeclaration);
        builder.append(", wcsProtocolDeclaration=");
        builder.append(this.wcsProtocolDeclaration);
        builder.append(", httpProtocolDeclaration=");
        builder.append(this.httpProtocolDeclaration);
        builder.append(", defaultCRS=");
        builder.append(this.defaultCRS);
        builder.append(", projectName=");
        builder.append(this.projectName);
        builder.append(", projectCitation=");
        builder.append(this.projectCitation);
        builder.append(", distributorIndividualName=");
        builder.append(this.distributorIndividualName);
        builder.append(", distributorOrganisationName=");
        builder.append(this.distributorOrganisationName);
        builder.append(", distributorEMail=");
        builder.append(this.distributorEMail);
        builder.append(", distributorSite=");
        builder.append(this.distributorSite);
        builder.append(", providerIndividualName=");
        builder.append(this.providerIndividualName);
        builder.append(", providerOrganisationName=");
        builder.append(this.providerOrganisationName);
        builder.append(", providerEMail=");
        builder.append(this.providerEMail);
        builder.append(", providerSite=");
        builder.append(this.providerSite);
        builder.append(", license=");
        builder.append(this.license);
        builder.append(", thesauri=");
        builder.append(this.thesauri);
        builder.append("]");
        return builder.toString();
    }

    public String toXML() {
        return xstream.toXML((Object)this);
    }
}

