/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.kml.bindings;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.kml.KML;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;

public class MultiGeometryTypeBinding
extends AbstractComplexBinding {
    GeometryFactory geometryFactory;

    public MultiGeometryTypeBinding(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    @Override
    public QName getTarget() {
        return KML.MultiGeometryType;
    }

    @Override
    public Class getType() {
        return GeometryCollection.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List geometries = node.getChildValues(Geometry.class);
        if (geometries.isEmpty()) {
            return this.geometryFactory.createGeometryCollection(new Geometry[0]);
        }
        int i = 0;
        Class<?> geometryClass = geometries.get(i++).getClass();
        while (i < geometries.size()) {
            Class<?> clazz = geometries.get(i).getClass();
            if (!clazz.isAssignableFrom(geometryClass) && !geometryClass.isAssignableFrom(clazz)) {
                geometryClass = null;
                break;
            }
            ++i;
        }
        if (geometryClass != null) {
            if (geometryClass == Point.class) {
                return this.geometryFactory.createMultiPoint(geometries.toArray(new Point[geometries.size()]));
            }
            if (geometryClass == LineString.class || geometryClass == LinearRing.class) {
                return this.geometryFactory.createMultiLineString(geometries.toArray(new LineString[geometries.size()]));
            }
            if (geometryClass == Polygon.class) {
                return this.geometryFactory.createMultiPolygon(geometries.toArray(new Polygon[geometries.size()]));
            }
        }
        return this.geometryFactory.createGeometryCollection(geometries.toArray(new Geometry[geometries.size()]));
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        GeometryCollection gc = (GeometryCollection)object;
        if (KML.Geometry.equals(name)) {
            Geometry[] g = new Geometry[gc.getNumGeometries()];
            for (int i = 0; i < g.length; ++i) {
                g[i] = gc.getGeometryN(i);
            }
            return g;
        }
        return null;
    }
}

