/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.referencing;

import javax.measure.unit.NonSI;
import org.junit.Assume;
import org.junit.Test;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.test.Assert;
import org.opengis.test.TestCase;
import org.opengis.test.Validators;
import org.opengis.util.FactoryException;

public abstract class CRSTest
extends TestCase {
    protected final CRSAuthorityFactory factory;

    protected CRSTest(CRSAuthorityFactory cRSAuthorityFactory) {
        this.factory = cRSAuthorityFactory;
    }

    @Test
    public void testCRSAuthorityCreation() throws NoSuchAuthorityCodeException, FactoryException {
        Assume.assumeNotNull((Object[])new Object[]{this.factory});
        GeographicCRS geographicCRS = this.factory.createGeographicCRS("EPSG:4326");
        Validators.validate(geographicCRS);
        Assert.assertNotNull((Object)geographicCRS);
        Assert.assertEquals((Object)"WGS 84", (Object)geographicCRS.getName().getCode());
        EllipsoidalCS ellipsoidalCS = geographicCRS.getCoordinateSystem();
        CoordinateSystemAxis coordinateSystemAxis = ellipsoidalCS.getAxis(0);
        CoordinateSystemAxis coordinateSystemAxis2 = ellipsoidalCS.getAxis(1);
        Assert.assertEquals((Object)"Geodetic latitude", (Object)coordinateSystemAxis.getName().getCode());
        Assert.assertEquals((Object)AxisDirection.NORTH, (Object)coordinateSystemAxis.getDirection());
        Assert.assertEquals((Object)NonSI.DEGREE_ANGLE, coordinateSystemAxis.getUnit());
        Assert.assertEquals((Object)"Geodetic longitude", (Object)coordinateSystemAxis2.getName().getCode());
        Assert.assertEquals((Object)AxisDirection.EAST, (Object)coordinateSystemAxis2.getDirection());
        Assert.assertEquals((Object)NonSI.DEGREE_ANGLE, coordinateSystemAxis2.getUnit());
        GeodeticDatum geodeticDatum = geographicCRS.getDatum();
        Assert.assertEquals((Object)"World Geodetic System 1984", (Object)geodeticDatum.getName().getCode());
        PrimeMeridian primeMeridian = geodeticDatum.getPrimeMeridian();
        Assert.assertEquals((double)0.0, (double)primeMeridian.getGreenwichLongitude(), (double)0.0);
        Assert.assertEquals((Object)NonSI.DEGREE_ANGLE, primeMeridian.getAngularUnit());
    }
}

