/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.referencing;

import java.util.List;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.Formula;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.test.Assert;
import org.opengis.test.ValidatorContainer;
import org.opengis.test.referencing.ReferencingValidator;

public class OperationValidator
extends ReferencingValidator {
    public OperationValidator(ValidatorContainer validatorContainer) {
        super(validatorContainer, "org.opengis.referencing.operation");
    }

    public void dispatch(CoordinateOperation coordinateOperation) {
        if (coordinateOperation instanceof Conversion) {
            this.validate((Conversion)coordinateOperation);
        } else if (coordinateOperation instanceof Transformation) {
            this.validate((Transformation)coordinateOperation);
        } else if (coordinateOperation instanceof ConcatenatedOperation) {
            this.validate((ConcatenatedOperation)coordinateOperation);
        } else if (coordinateOperation instanceof PassThroughOperation) {
            this.validate((PassThroughOperation)coordinateOperation);
        } else if (coordinateOperation instanceof SingleOperation) {
            this.validateOperation((SingleOperation)coordinateOperation);
        } else {
            this.validateCoordinateOperation(coordinateOperation);
        }
    }

    public void validate(PassThroughOperation passThroughOperation) {
        if (passThroughOperation == null) {
            return;
        }
        this.validateCoordinateOperation(passThroughOperation);
        MathTransform mathTransform = passThroughOperation.getMathTransform();
        this.mandatory("PassThroughOperation: shall have a MathTransform.", mathTransform);
        SingleOperation singleOperation = passThroughOperation.getOperation();
        this.mandatory("PassThroughOperation: getOperation() is mandatory.", singleOperation);
        Assert.assertNotSame((String)"PassThroughOperation: getOperation() can't be this.", (Object)passThroughOperation, (Object)singleOperation);
        this.dispatch(singleOperation);
        int[] nArray = passThroughOperation.getModifiedCoordinates();
        this.mandatory("PassThroughOperation: modified coordinates are mandatory.", nArray);
        if (singleOperation == null || nArray == null) {
            return;
        }
        OperationMethod operationMethod = singleOperation.getMethod();
        if (operationMethod == null) {
            return;
        }
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        Integer n3 = operationMethod.getSourceDimensions();
        Integer n4 = operationMethod.getTargetDimensions();
        if (n3 != null) {
            Assert.assertEquals((String)"PassThroughOperation: the number of modified ordinates must match the source dimension of the operation to apply.", (long)n3.intValue(), (long)nArray.length);
            if (n4 != null) {
                Assert.assertEquals((String)"PassThroughOperation: wrong target dimension.", (long)(n + (n3 - n4)), (long)n2);
            }
        }
        for (int n5 : nArray) {
            Assert.assertBetween("PassThroughOperation: invalid modified ordinate index.", 0, n - 1, n5);
        }
    }

    public void validate(ConcatenatedOperation concatenatedOperation) {
        Object object;
        Object object2;
        Object object3;
        if (concatenatedOperation == null) {
            return;
        }
        this.validateCoordinateOperation(concatenatedOperation);
        MathTransform mathTransform = concatenatedOperation.getMathTransform();
        this.mandatory("ConcatenatedOperation: shall have a MathTransform.", mathTransform);
        List<SingleOperation> list = concatenatedOperation.getOperations();
        this.mandatory("ConcatenatedOperation: shall provide a list of single operations.", list);
        if (list == null) {
            return;
        }
        CoordinateOperation object5 = null;
        CoordinateOperation object6 = null;
        for (SingleOperation object42 : list) {
            Assert.assertNotNull((String)"ConcatenatedOperation: getOperations() can't contain null element.", (Object)object42);
            Assert.assertNotSame((String)"ConcatenatedOperation: can't contain itself as a single element.", (Object)object42, (Object)concatenatedOperation);
            this.dispatch(object42);
            if (object5 == null) {
                object5 = object42;
            } else {
                object3 = object6.getMathTransform();
                object2 = object42.getMathTransform();
                if (object3 != null && object2 != null) {
                    Assert.assertEquals((String)"ConcatenatedOperation: source dimension of a single operation must match the target dimension of the previous one.", (long)object3.getTargetDimensions(), (long)object2.getSourceDimensions());
                }
                CoordinateReferenceSystem coordinateReferenceSystem = object6.getTargetCRS();
                CoordinateReferenceSystem coordinateReferenceSystem2 = object42.getSourceCRS();
                if (coordinateReferenceSystem != null && coordinateReferenceSystem2 != null) {
                    Assert.assertEquals((String)"ConcatenatedOperation: source dimension of a single operation must match the target dimension of the previous one.", (long)OperationValidator.dimension(coordinateReferenceSystem), (long)OperationValidator.dimension(coordinateReferenceSystem2));
                }
            }
            object6 = object42;
        }
        Assert.assertNotNull((String)"ConcatenatedOperation: shall contain at least one single operation.", object6);
        if (mathTransform != null) {
            object = object5.getMathTransform();
            MathTransform mathTransform2 = object6.getMathTransform();
            if (object != null) {
                Assert.assertEquals((String)"ConcatenatedOperation: source dimension must match the source dimension of the first single operation.", (long)object.getSourceDimensions(), (long)mathTransform.getSourceDimensions());
            }
            if (mathTransform2 != null) {
                Assert.assertEquals((String)"ConcatenatedOperation: target dimension must match the target dimension of the last single operation.", (long)mathTransform2.getTargetDimensions(), (long)mathTransform.getTargetDimensions());
            }
        }
        object = concatenatedOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem = concatenatedOperation.getTargetCRS();
        object3 = object5.getSourceCRS();
        object2 = object6.getTargetCRS();
        if (object != null && object3 != null) {
            Assert.assertSame((String)"ConcatenatedOperation: sourceCRS must be the source of the first single operation.", (Object)object3, (Object)object);
        }
        if (coordinateReferenceSystem != null && object2 != null) {
            Assert.assertSame((String)"ConcatenatedOperation: targetCRS must be the target of the last single operation.", (Object)object2, (Object)coordinateReferenceSystem);
        }
    }

    private void validateCoordinateOperation(CoordinateOperation coordinateOperation) {
        if (coordinateOperation == null) {
            return;
        }
        Assert.assertFalse((String)"CoordinateOperation: can't be both a ConcatenatedOperation and a SingleOperation.", (coordinateOperation instanceof ConcatenatedOperation && coordinateOperation instanceof SingleOperation ? 1 : 0) != 0);
        this.validateIdentifiedObject(coordinateOperation);
        this.container.naming.validate(coordinateOperation.getScope());
        this.container.extent.validate(coordinateOperation.getDomainOfValidity());
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        CoordinateReferenceSystem coordinateReferenceSystem2 = coordinateOperation.getTargetCRS();
        this.container.crs.dispatch(coordinateReferenceSystem);
        this.container.crs.dispatch(coordinateReferenceSystem2);
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        this.validate(mathTransform);
        if (mathTransform != null) {
            if (coordinateReferenceSystem != null) {
                Assert.assertEquals((String)"CoordinateOperation: MathTransform source dimension must match sourceCRS dimension.", (long)OperationValidator.dimension(coordinateReferenceSystem), (long)mathTransform.getSourceDimensions());
            }
            if (coordinateReferenceSystem2 != null) {
                Assert.assertEquals((String)"CoordinateOperation: MathTransform target dimension must match targetCRS dimension.", (long)OperationValidator.dimension(coordinateReferenceSystem2), (long)mathTransform.getTargetDimensions());
            }
        }
    }

    private void validateOperation(SingleOperation singleOperation) {
        Object object;
        if (singleOperation == null) {
            return;
        }
        this.validateCoordinateOperation(singleOperation);
        Assert.assertFalse((String)"Operation: can't be both a Conversion and a Transformation.", (singleOperation instanceof Conversion && singleOperation instanceof Transformation ? 1 : 0) != 0);
        OperationMethod operationMethod = singleOperation.getMethod();
        this.mandatory("Operation: OperationMethod is mandatory.", operationMethod);
        if (operationMethod != null) {
            this.validate(operationMethod);
            object = operationMethod.getSourceDimensions();
            Integer n = operationMethod.getTargetDimensions();
            MathTransform mathTransform = singleOperation.getMathTransform();
            if (mathTransform != null) {
                if (object != null) {
                    Assert.assertEquals((String)"Operation: MathTransform source dimension must match OperationMethod source dimension.", (long)((Integer)object).intValue(), (long)mathTransform.getSourceDimensions());
                }
                if (n != null) {
                    Assert.assertEquals((String)"Operation: MathTransform target dimension must match OperationMethod target dimension.", (long)n.intValue(), (long)mathTransform.getTargetDimensions());
                }
            }
        }
        object = singleOperation.getParameterValues();
        this.mandatory("Operation: ParameterValues are mandatory.", operationMethod);
        this.container.parameter.validate((ParameterValueGroup)object);
    }

    public void validate(Conversion conversion) {
        if (conversion == null) {
            return;
        }
        this.validateOperation(conversion);
        Assert.assertFalse((String)"Projection: can't be both planar and conic.", (conversion instanceof PlanarProjection && conversion instanceof ConicProjection ? 1 : 0) != 0);
        Assert.assertFalse((String)"Projection: can't be both planar and cylindrical.", (conversion instanceof PlanarProjection && conversion instanceof CylindricalProjection ? 1 : 0) != 0);
        Assert.assertFalse((String)"Projection: can't be both cylindrical and conic.", (conversion instanceof CylindricalProjection && conversion instanceof ConicProjection ? 1 : 0) != 0);
        if (conversion.getMathTransform() != null) {
            this.mandatory("Conversion: non-defining conversion should have a source CRS.", conversion.getSourceCRS());
            this.mandatory("Conversion: non-defining conversion should have a target CRS.", conversion.getTargetCRS());
        }
        this.forbidden("Conversion: should not have operation version.", conversion.getOperationVersion());
        if (conversion.getMathTransform() == null) {
            this.forbidden("Conversion: defining conversion should not have source CRS", conversion.getSourceCRS());
            this.forbidden("Conversion: defining conversion should not have target CRS", conversion.getTargetCRS());
        }
    }

    public void validate(Transformation transformation) {
        if (transformation == null) {
            return;
        }
        this.validateOperation(transformation);
        this.mandatory("Transformation: operationVersion is a mandatory attribute.", transformation.getOperationVersion());
        this.mandatory("Transformation: sourceCRS is a mandatory attribute.", transformation.getSourceCRS());
        this.mandatory("Transformation: targetCRS is a mandatory attribute.", transformation.getTargetCRS());
        this.mandatory("Transformation: MathTransform is a mandatory attribute.", transformation.getMathTransform());
    }

    public void validate(OperationMethod operationMethod) {
        if (operationMethod == null) {
            return;
        }
        Integer n = operationMethod.getSourceDimensions();
        Integer n2 = operationMethod.getTargetDimensions();
        if (n != null) {
            Assert.assertStrictlyPositive("OperationMethod: source dimension must be greater than zero.", n);
        }
        if (n2 != null) {
            Assert.assertStrictlyPositive("OperationMethod: target dimension must be greater than zero.", n2);
        }
        this.validate(operationMethod.getFormula());
        this.container.parameter.validate(operationMethod.getParameters());
        this.validateIdentifiedObject(operationMethod);
    }

    public void validate(Formula formula) {
        if (formula == null) {
            return;
        }
        this.container.naming.validate(formula.getFormula());
        this.container.citation.validate(formula.getCitation());
    }

    public void validate(MathTransform mathTransform) {
        if (mathTransform == null) {
            return;
        }
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform.getTargetDimensions();
        Assert.assertStrictlyPositive("MathTransform: source dimension must be greater than zero.", n);
        Assert.assertStrictlyPositive("MathTransform: target dimension must be greater than zero.", n2);
        if (mathTransform instanceof MathTransform1D) {
            Assert.assertEquals((String)"MathTransform1D: source dimension must be 1.", (long)1L, (long)n);
            Assert.assertEquals((String)"MathTransform1D: target dimension must be 1.", (long)1L, (long)n2);
        }
        if (mathTransform instanceof MathTransform2D) {
            Assert.assertEquals((String)"MathTransform2D: source dimension must be 2.", (long)2L, (long)n);
            Assert.assertEquals((String)"MathTransform2D: target dimension must be 2.", (long)2L, (long)n2);
        }
        if (mathTransform.isIdentity()) {
            Assert.assertEquals((String)"MathTransform: identity transforms must have the same source and target dimensions.", (long)n, (long)n2);
        }
    }

    private static int dimension(CoordinateReferenceSystem coordinateReferenceSystem) {
        return coordinateReferenceSystem.getCoordinateSystem().getDimension();
    }
}

