/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.referencing;

import java.util.List;
import java.util.Set;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.test.Assert;
import org.opengis.test.ValidatorContainer;
import org.opengis.test.referencing.ReferencingValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterValidator
extends ReferencingValidator {
    public ParameterValidator(ValidatorContainer validatorContainer) {
        super(validatorContainer, "org.opengis.parameter");
    }

    public void dispatch(GeneralParameterDescriptor generalParameterDescriptor) {
        if (generalParameterDescriptor instanceof ParameterDescriptor) {
            this.validate((ParameterDescriptor)generalParameterDescriptor);
        } else if (generalParameterDescriptor instanceof ParameterDescriptorGroup) {
            this.validate((ParameterDescriptorGroup)generalParameterDescriptor);
        } else {
            this.validateIdentifiedObject(generalParameterDescriptor);
        }
    }

    public void dispatch(GeneralParameterValue generalParameterValue) {
        if (generalParameterValue instanceof ParameterValue) {
            this.validate((ParameterValue)generalParameterValue);
        } else if (generalParameterValue instanceof ParameterValueGroup) {
            this.validate((ParameterValueGroup)generalParameterValue);
        }
    }

    public <T> void validate(ParameterDescriptor<T> parameterDescriptor) {
        Comparable<Object> comparable;
        Object object;
        if (parameterDescriptor == null) {
            return;
        }
        this.validateIdentifiedObject(parameterDescriptor);
        Class<T> clazz = parameterDescriptor.getValueClass();
        this.mandatory("ParameterDescriptor: getValueClass() can not return null.", clazz);
        Set<T> set = parameterDescriptor.getValidValues();
        if (set != null) {
            object = set.iterator();
            while (object.hasNext()) {
                comparable = object.next();
                if (comparable == null) continue;
                Assert.assertInstanceOf("ParameterDescriptor: getValidValues() has unexpected element.", clazz, comparable);
            }
        }
        if ((object = parameterDescriptor.getMinimumValue()) != null) {
            Assert.assertInstanceOf("ParameterDescriptor: getMinimumValue() returns unexpected value.", clazz, object);
        }
        if ((comparable = parameterDescriptor.getMaximumValue()) != null) {
            Assert.assertInstanceOf("ParameterDescriptor: getMaximumValue() returns unexpected value.", clazz, comparable);
        }
        Assert.assertValidRange("ParameterDescriptor: inconsistent minimum and maximum values.", object, comparable);
        T t = parameterDescriptor.getDefaultValue();
        if (t != null) {
            Assert.assertInstanceOf("ParameterDescriptor: getDefaultValue() returns unexpected value.", clazz, t);
            Assert.assertBetween("ParameterDescriptor: getDefaultValue() out of range.", object, comparable, t);
        }
        Assert.assertBetween("ParameterDescriptor: getMinimumOccurs() shall returns 0 or 1.", 0, 1, parameterDescriptor.getMinimumOccurs());
        Assert.assertEquals((String)"ParameterDescriptor: getMaximumOccurs() shall returns exactly 1.", (long)1L, (long)parameterDescriptor.getMaximumOccurs());
    }

    public void validate(ParameterDescriptorGroup parameterDescriptorGroup) {
        if (parameterDescriptorGroup == null) {
            return;
        }
        this.validateIdentifiedObject(parameterDescriptorGroup);
        List<GeneralParameterDescriptor> list = parameterDescriptorGroup.descriptors();
        this.mandatory("ParameterDescriptorGroup: descriptors() should not return null.", list);
        if (list != null) {
            for (GeneralParameterDescriptor generalParameterDescriptor : list) {
                Assert.assertNotNull((String)"ParameterDescriptorGroup: descriptors() can not contain null element.", (Object)generalParameterDescriptor);
                this.dispatch(generalParameterDescriptor);
                GeneralParameterDescriptor generalParameterDescriptor2 = parameterDescriptorGroup.descriptor(generalParameterDescriptor.getName().getCode());
                this.mandatory("ParameterDescriptorGroup: descriptor(String) should returns a value.", generalParameterDescriptor2);
                if (generalParameterDescriptor2 == null) continue;
                Assert.assertSame((String)"ParameterDescriptorGroup: descriptor(String) inconsistent with descriptors().", (Object)generalParameterDescriptor, (Object)generalParameterDescriptor2);
            }
        }
        int n = parameterDescriptorGroup.getMinimumOccurs();
        Assert.assertPositive("ParameterDescriptor: getMinimumOccurs() can not be negative.", n);
        Assert.assertValidRange("ParameterDescriptor: getMaximumOccurs() gives inconsistent range.", n, parameterDescriptorGroup.getMaximumOccurs());
    }

    public <T> void validate(ParameterValue<T> parameterValue) {
        if (parameterValue == null) {
            return;
        }
        ParameterDescriptor<T> parameterDescriptor = parameterValue.getDescriptor();
        this.mandatory("ParameterValue: must have a descriptor.", parameterDescriptor);
        this.validate(parameterDescriptor);
        T t = parameterValue.getValue();
        if (t != null && parameterDescriptor != null) {
            Class<T> clazz = parameterDescriptor.getValueClass();
            Assert.assertInstanceOf("ParameterValue: getValue() returns unexpected value.", clazz, t);
            Set<T> set = parameterDescriptor.getValidValues();
            if (set != null) {
                Assert.assertContains("ParameterValue: getValue() not a member of getValidValues() set.", set, t);
            }
            Assert.assertBetween("ParameterValue: getValue() is out of bounds.", parameterDescriptor.getMinimumValue(), parameterDescriptor.getMaximumValue(), t);
        }
    }

    public void validate(ParameterValueGroup parameterValueGroup) {
        if (parameterValueGroup == null) {
            return;
        }
        ParameterDescriptorGroup parameterDescriptorGroup = parameterValueGroup.getDescriptor();
        this.mandatory("ParameterValueGroup: must have a descriptor.", parameterDescriptorGroup);
        this.validate(parameterDescriptorGroup);
        List<GeneralParameterValue> list = parameterValueGroup.values();
        this.mandatory("ParameterValueGroup: values() should not return null.", list);
        if (list == null) {
            return;
        }
        for (GeneralParameterValue generalParameterValue : list) {
            Object object;
            Assert.assertNotNull((String)"ParameterValueGroup: values() can not contain null element.", (Object)generalParameterValue);
            this.dispatch(generalParameterValue);
            GeneralParameterDescriptor generalParameterDescriptor = generalParameterValue.getDescriptor();
            this.mandatory("GeneralParameterValue: expected a descriptor.", generalParameterDescriptor);
            if (generalParameterDescriptor == null) continue;
            String string = generalParameterDescriptor.getName().getCode();
            this.mandatory("GeneralParameterDescriptor: expected a name.", string);
            if (string == null) continue;
            if (parameterDescriptorGroup != null) {
                object = parameterDescriptorGroup.descriptor(string);
                this.mandatory("ParameterDescriptorGroup: should never return null.", object);
                if (object != null) {
                    Assert.assertSame((String)"ParameterValueGroup: descriptor(String) inconsistent with value.getDescriptor().", (Object)generalParameterDescriptor, (Object)object);
                }
            }
            if (!(generalParameterValue instanceof ParameterValue)) continue;
            object = parameterValueGroup.parameter(string);
            this.mandatory("ParameterValueGroup: parameter(String) should returns a value.", object);
            if (object == null) continue;
            Assert.assertSame((String)"ParameterValueGroup: value(String) inconsistent with values().", (Object)generalParameterValue, (Object)object);
        }
    }
}

