/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.cxml;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.geoserverinterface.cxml.CXmlManager;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXml {
    private Type type;
    private Document doc;
    private Element element;
    private String text = null;
    private List<Element> elements = new ArrayList<Element>();
    private List<CXml> children = new ArrayList<CXml>();

    public CXml(Document doc, String tagName) {
        this.doc = doc;
        this.element = doc.createElement(tagName);
        this.type = Type.DOCUMENT;
    }

    public CXml(Document doc, String tagName, String text) {
        this.doc = doc;
        this.element = doc.createElement(tagName);
        this.text(text);
        this.type = Type.DOCUMENT;
    }

    public CXml(Document doc) {
        this.doc = doc;
        this.element = doc.getDocumentElement();
        this.type = Type.DOCUMENT;
    }

    public CXml(Element e) {
        this.element = e;
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            this.text = ((CharacterData)child).getData();
        }
        this.type = Type.ELEMENT;
    }

    public CXml(List<Element> elements) {
        this.elements = elements;
        this.type = Type.ELEMENTS;
    }

    public CXml() {
        this.type = Type.NULL;
    }

    public CXml(String xml) {
        this(CXml.getDocument(xml));
    }

    public String tagName() {
        try {
            return this.element.getTagName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void attr(String name, String value) {
        Attr attr = this.doc.createAttribute(name);
        attr.setValue(value);
        this.element.getAttributes().setNamedItem(attr);
    }

    public void attr(String name, int value) {
        this.attr(name, "" + value);
    }

    public String attr(String name) {
        if (this.type == Type.DOCUMENT || this.type == Type.ELEMENT) {
            return this.element.getAttribute(name);
        }
        return null;
    }

    public String getAttr(String name) {
        return this.attr(name);
    }

    public void text(String text) {
        if (text != null) {
            this.removeChildren();
            this.element.appendChild(this.doc.createTextNode(text));
            this.text = text;
        }
    }

    public void setText(String text) {
        this.text(text);
    }

    public String text() {
        return this.text;
    }

    public String getText() {
        return this.text();
    }

    public void append(CXml cXml) {
        this.element.appendChild(cXml.element);
        this.children.add(cXml);
    }

    public void appendTo(CXml cXml) {
        cXml.element.appendChild(this.element);
        cXml.children.add(this);
    }

    public void removeChildren() {
        NodeList nodeList = this.element.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            this.element.removeChild(node);
            ++i;
        }
        this.children.clear();
    }

    public String toString() {
        this.doc.appendChild(this.element);
        String xmlString = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(this.doc);
            transformer.transform(source, result);
            xmlString = result.getWriter().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlString;
    }

    public void each(CXmlManager manager) {
        if (this.type == Type.DOCUMENT || this.type == Type.ELEMENT) {
            manager.manage(0, this);
        } else if (this.type == Type.ELEMENTS) {
            int i = 0;
            for (Element e : this.elements) {
                CXml cXml = new CXml(e);
                manager.manage(i++, cXml);
            }
        }
    }

    public static Document getNewDocument() {
        Document doc = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static Document getDocument(String xml) {
        Document doc = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            doc = docBuilder.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public CXml find(String tagName) {
        if (this.type == Type.DOCUMENT || this.type == Type.ELEMENT) {
            NodeList nodeList = this.element.getElementsByTagName(tagName);
            if (nodeList.getLength() == 1) {
                return new CXml((Element)nodeList.item(0));
            }
            if (nodeList.getLength() > 1) {
                ArrayList<Element> elements = new ArrayList<Element>();
                int i = 0;
                while (i < nodeList.getLength()) {
                    elements.add((Element)nodeList.item(i));
                    ++i;
                }
                return new CXml(elements);
            }
            return new CXml();
        }
        return new CXml();
    }

    public CXml findFirst(String tagName) {
        NodeList nodeList;
        if ((this.type == Type.DOCUMENT || this.type == Type.ELEMENT) && (nodeList = this.element.getElementsByTagName(tagName)).getLength() > 0) {
            return new CXml((Element)nodeList.item(0));
        }
        return new CXml();
    }

    public CXml children(String tagName) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (this.type == Type.DOCUMENT || this.type == Type.ELEMENT) {
            NodeList nodeList = this.element.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Element e;
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 && (e = (Element)node).getTagName().equalsIgnoreCase(tagName)) {
                    elements.add(e);
                }
                ++i;
            }
            return new CXml(elements);
        }
        return new CXml();
    }

    public CXml child(String tagName) {
        if (this.type == Type.DOCUMENT || this.type == Type.ELEMENT) {
            NodeList nodeList = this.element.getChildNodes();
            int l = nodeList.getLength();
            int i = 0;
            while (i < nodeList.getLength()) {
                Element e;
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 && (e = (Element)node).getTagName().equalsIgnoreCase(tagName)) {
                    return new CXml(e);
                }
                ++i;
            }
        }
        return new CXml();
    }

    public boolean isNull() {
        return this.type == Type.NULL;
    }

    public boolean isDocument() {
        return this.type == Type.DOCUMENT;
    }

    public boolean isElement() {
        return this.type == Type.DOCUMENT || this.type == Type.ELEMENT;
    }

    public boolean isElements() {
        return this.type == Type.ELEMENTS;
    }

    public static void main(String[] args) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><people>\t<member id='21'>\t\t<name>ciccio</name>\t\t<surname>ceras</surname>\t\t<category>senior programmer</category>\t</member>\t<member id='16'>\t\t<name>pinco</name>\t\t<surname>pallino</surname>\t\t<category>analist programmer</category>\t</member></people>";
        CXml rootPeople = new CXml(xml);
        rootPeople.children("member").each(new CXmlManager(){

            public void manage(int i, CXml member) {
                System.out.println("MEMBER " + member.attr("id") + ": " + member.child("name").text + " " + member.child("surname").text + " (" + member.child("category").text + ")");
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        DOCUMENT,
        ELEMENT,
        ELEMENTS,
        NULL;

    }
}

