/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import com.vividsolutions.jts.geom.Envelope;
import javax.xml.namespace.QName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.v1_0.OGC;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.gml3.GML;
import org.geotools.referencing.CRS;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OGCBBOXTypeBinding
extends AbstractComplexBinding {
    private FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
    private CoordinateReferenceSystem crs;

    public QName getTarget() {
        return OGC.BBOXType;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public Class getType() {
        return BBOX.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        String srs;
        PropertyName propertyName = (PropertyName)node.getChildValue(PropertyName.class);
        Envelope box = (Envelope)node.getChildValue(Envelope.class);
        Node srsNode = node.getChild(Envelope.class).getAttribute("srsName");
        String string = srs = srsNode != null ? srsNode.getValue().toString() : null;
        if (srs == null && this.crs != null) {
            srs = GML2EncodingUtils.crs((CoordinateReferenceSystem)this.crs);
        }
        String name = null;
        if (propertyName != null) {
            name = propertyName.getPropertyName();
        }
        if (name == null) {
            name = "";
        }
        return this.factory.bbox(name, box.getMinX(), box.getMinY(), box.getMaxX(), box.getMaxY(), srs);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        BBOX box = (BBOX)object;
        if (OGC.PropertyName.equals(name)) {
            return this.factory.property(box.getPropertyName());
        }
        if (org.geotools.gml2.GML.Box.equals(name) || GML.Envelope.equals(name)) {
            try {
                String srs = box.getSRS();
                if (srs != null) {
                    CoordinateReferenceSystem crs = CRS.decode(srs);
                    return new ReferencedEnvelope(box.getMinX(), box.getMaxX(), box.getMinY(), box.getMaxY(), crs);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            return new Envelope(box.getMinX(), box.getMaxX(), box.getMinY(), box.getMaxY());
        }
        return null;
    }
}

