/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogWriterDecorator
extends Writer {
    private Writer delegate;
    private Level level;
    StringBuffer buffer = new StringBuffer("Output: ");
    private Logger logger;

    public LogWriterDecorator(Writer w, Logger logger, Level logLevel) {
        this.delegate = w;
        this.level = logLevel;
        this.logger = logger;
    }

    @Override
    public synchronized void close() throws IOException {
        this.delegate.close();
        this.logger.log(this.level, this.buffer.toString());
        this.buffer = new StringBuffer("Output: ");
    }

    @Override
    public synchronized void flush() throws IOException {
        this.delegate.flush();
        this.logger.log(this.level, this.buffer.toString());
        this.buffer = new StringBuffer("Output: ");
    }

    @Override
    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        char[] msg = new char[len];
        System.arraycopy(cbuf, off, msg, 0, len);
        this.buffer.append(msg);
        this.delegate.write(cbuf, off, len);
    }
}

