/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FilterVisitor2;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.xml.filter.UnsupportedFilterException;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.identity.FeatureId;

public class FilterEncodingPreProcessor
implements FilterVisitor,
FilterVisitor2 {
    private static final int LOW = 0;
    private static final int MEDIUM = 1;
    private static final int HIGH = 2;
    private int complianceInt;
    private Stack<Data> current = new Stack();
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private boolean requiresPostProcessing = false;

    public FilterEncodingPreProcessor(Integer complianceLevel) {
        if (complianceLevel != 0 && complianceLevel != 1 && complianceLevel != 2) {
            throw new IllegalArgumentException("compliance level must be one of: XMLHandlerHints.VALUE_FILTER_COMPLIANCE_LOOSE XMLHandlerHints.VALUE_FILTER_COMPLIANCE_MEDIUM or XMLHandlerHints.VALUE_FILTER_COMPLIANCE_MAXIMUM");
        }
        this.complianceInt = complianceLevel;
    }

    public FidFilter getFidFilter() {
        if (this.current.isEmpty()) {
            Set empty = Collections.emptySet();
            return (FidFilter)this.ff.id(empty);
        }
        Data data = this.current.peek();
        if (data.fids.size() > 0) {
            HashSet<FeatureId> set = new HashSet<FeatureId>();
            Set fids = data.fids;
            for (String fid : fids) {
                set.add(this.ff.featureId(fid));
            }
            return (FidFilter)this.ff.id(set);
        }
        Set empty = Collections.emptySet();
        return (FidFilter)this.ff.id(empty);
    }

    public Filter getFilter() {
        if (this.current.isEmpty()) {
            return org.geotools.filter.Filter.EXCLUDE;
        }
        return this.current.peek().filter;
    }

    public void visit(org.geotools.filter.Filter filter) {
        if (filter instanceof BetweenFilter || filter instanceof BetweenFilter || filter instanceof CompareFilter || filter instanceof GeometryFilter || filter instanceof LikeFilter || filter instanceof LogicFilter || filter instanceof NullFilter || filter instanceof FidFilter) {
            filter.accept((FilterVisitor)this);
        } else {
            this.current.push(new Data(filter));
        }
    }

    public void visit(BetweenFilter filter) {
        this.current.push(new Data((org.geotools.filter.Filter)filter));
    }

    public void visit(CompareFilter filter) {
        this.current.push(new Data((org.geotools.filter.Filter)filter));
    }

    public void visit(GeometryFilter filter) {
        this.current.push(new Data((org.geotools.filter.Filter)filter));
    }

    public void visit(LikeFilter filter) {
        this.current.push(new Data((org.geotools.filter.Filter)filter));
    }

    public void visit(LogicFilter filter) {
        int startSize = this.current.size();
        try {
            switch (this.complianceInt) {
                case 0: {
                    this.current.push(new Data((org.geotools.filter.Filter)filter));
                    break;
                }
                case 1: {
                    Iterator iter = filter.getFilterIterator();
                    while (iter.hasNext()) {
                        org.geotools.filter.Filter component = (org.geotools.filter.Filter)iter.next();
                        component.accept((FilterVisitor)this);
                    }
                    this.current.push(this.createMediumLevelLogicFilter(filter.getFilterType(), startSize));
                    break;
                }
                case 2: {
                    Iterator iter = filter.getFilterIterator();
                    while (iter.hasNext()) {
                        org.geotools.filter.Filter component = (org.geotools.filter.Filter)iter.next();
                        component.accept((FilterVisitor)this);
                    }
                    this.current.push(this.createHighLevelLogicFilter(filter.getFilterType(), startSize));
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedFilterException) {
                throw (UnsupportedFilterException)e;
            }
            throw new UnsupportedFilterException("Exception creating filter", e);
        }
    }

    private Data createMediumLevelLogicFilter(short filterType, int startOfFilterStack) throws IllegalFilterException {
        Data resultingFilter;
        switch (filterType) {
            case 2: {
                Set fids = this.andFids(startOfFilterStack);
                resultingFilter = this.buildFilter(filterType, startOfFilterStack);
                resultingFilter.fids.addAll(fids);
                if (resultingFilter.filter == org.geotools.filter.Filter.EXCLUDE || fids.isEmpty()) break;
                this.requiresPostProcessing = true;
                break;
            }
            case 1: {
                Set fids = this.orFids(startOfFilterStack);
                resultingFilter = this.buildFilter(filterType, startOfFilterStack);
                resultingFilter.fids.addAll(fids);
                break;
            }
            case 3: {
                resultingFilter = this.buildFilter(filterType, startOfFilterStack);
                break;
            }
            default: {
                resultingFilter = this.buildFilter(filterType, startOfFilterStack);
            }
        }
        return resultingFilter;
    }

    private Set orFids(int startOfFilterStack) {
        HashSet set = new HashSet();
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.fids.isEmpty()) continue;
            set.addAll(data.fids);
        }
        return set;
    }

    private Set andFids(int startOfFilterStack) {
        if (!this.hasFidFilter(startOfFilterStack)) {
            return Collections.EMPTY_SET;
        }
        HashSet<Data> toRemove = new HashSet<Data>();
        ArrayList<Set> fidSet = new ArrayList<Set>();
        boolean doRemove = true;
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.fids.isEmpty()) {
                toRemove.add(data);
                continue;
            }
            fidSet.add(data.fids);
            if (data.filter == org.geotools.filter.Filter.EXCLUDE) continue;
            doRemove = false;
        }
        if (doRemove) {
            this.current.removeAll(toRemove);
        }
        if (fidSet.size() == 0) {
            return Collections.EMPTY_SET;
        }
        if (fidSet.size() == 1) {
            return (Set)fidSet.get(0);
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < fidSet.size(); ++i) {
            Set tmp = (Set)fidSet.get(i);
            for (String fid : tmp) {
                if (!this.allContain(fid, fidSet)) continue;
                set.add(fid);
            }
        }
        return set;
    }

    private boolean allContain(String fid, List fidSets) {
        for (int i = 0; i < fidSets.size(); ++i) {
            Set tmp = (Set)fidSets.get(i);
            if (tmp.contains(fid)) continue;
            return false;
        }
        return true;
    }

    private Data buildFilter(short filterType, int startOfFilterStack) throws IllegalFilterException {
        if (this.current.isEmpty()) {
            return Data.ALL;
        }
        if (filterType == 3) {
            return this.buildNotFilter(startOfFilterStack);
        }
        if (this.current.size() == startOfFilterStack + 1) {
            return this.current.pop();
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        while (this.current.size() > startOfFilterStack) {
            Data data = this.current.pop();
            if (data.filter == org.geotools.filter.Filter.EXCLUDE) continue;
            filterList.add(data.filter);
        }
        Object f = filterType == 2 ? this.ff.and(filterList) : (filterType == 1 ? this.ff.or(filterList) : null);
        return new Data(this.compressFilter(filterType, (LogicFilter)f));
    }

    private Filter compressFilter(short filterType, LogicFilter f) throws IllegalFilterException {
        LogicFilter result;
        int added = 0;
        ArrayList<Filter> resultList = new ArrayList<Filter>();
        switch (filterType) {
            case 2: {
                if (this.contains(f, (Filter)org.geotools.filter.Filter.EXCLUDE)) {
                    return org.geotools.filter.Filter.EXCLUDE;
                }
                for (Object item : f.getChildren()) {
                    Filter filter = (Filter)item;
                    if (filter == org.geotools.filter.Filter.INCLUDE) continue;
                    ++added;
                    resultList.add(filter);
                }
                if (resultList.isEmpty()) {
                    return org.geotools.filter.Filter.EXCLUDE;
                }
                result = (LogicFilter)this.ff.and(resultList);
                break;
            }
            case 1: {
                if (this.contains(f, (Filter)org.geotools.filter.Filter.INCLUDE)) {
                    return org.geotools.filter.Filter.INCLUDE;
                }
                for (Object item : f.getChildren()) {
                    Filter filter = (Filter)item;
                    if (filter == org.geotools.filter.Filter.ALL) continue;
                    ++added;
                    resultList.add(filter);
                }
                if (resultList.isEmpty()) {
                    return org.geotools.filter.Filter.EXCLUDE;
                }
                result = (LogicFilter)this.ff.or(resultList);
                break;
            }
            default: {
                return org.geotools.filter.Filter.EXCLUDE;
            }
        }
        switch (added) {
            case 0: {
                return org.geotools.filter.Filter.EXCLUDE;
            }
            case 1: {
                return (org.geotools.filter.Filter)result.getFilterIterator().next();
            }
        }
        return result;
    }

    private boolean contains(LogicFilter f, Filter toFind) {
        Iterator iter = f.getChildren().iterator();
        while (iter.hasNext()) {
            if (!toFind.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    private Data buildNotFilter(int startOfFilterStack) {
        if (this.current.size() > startOfFilterStack + 1) {
            throw new UnsupportedFilterException("A not filter cannot have more than one filter");
        }
        Data tmp = this.current.pop();
        Data data = new Data((Filter)this.ff.not(tmp.filter));
        if (!tmp.fids.isEmpty()) {
            data.filter = org.geotools.filter.Filter.NONE;
            data.fids.clear();
            this.requiresPostProcessing = true;
        }
        return data;
    }

    private Data createHighLevelLogicFilter(short filterType, int startOfFilterStack) throws IllegalFilterException {
        if (this.hasFidFilter(startOfFilterStack)) {
            switch (filterType) {
                case 2: {
                    Set fids = this.andFids(startOfFilterStack);
                    Data filter = this.buildFilter(filterType, startOfFilterStack);
                    filter.fids.addAll(fids);
                    return filter;
                }
                case 1: {
                    if (this.hasNonFidFilter(startOfFilterStack)) {
                        throw new UnsupportedFilterException("Maximum compliance does not allow Logic filters to contain FidFilters");
                    }
                    Set fids = this.orFids(startOfFilterStack);
                    this.pop(startOfFilterStack);
                    Data data = new Data();
                    data.fids.addAll(fids);
                    return data;
                }
                case 3: {
                    return this.buildFilter(filterType, startOfFilterStack);
                }
            }
            return Data.ALL;
        }
        return this.buildFilter(filterType, startOfFilterStack);
    }

    private void pop(int startOfFilterStack) {
        while (this.current.size() > startOfFilterStack) {
            this.current.pop();
        }
    }

    private boolean hasNonFidFilter(int startOfFilterStack) {
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.filter == org.geotools.filter.Filter.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private boolean hasFidFilter(int startOfFilterStack) {
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.fids.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void visit(NullFilter filter) {
        this.current.push(new Data((org.geotools.filter.Filter)filter));
    }

    public void visit(FidFilter filter) {
        Data data = new Data();
        data.fids.addAll(Arrays.asList(filter.getFids()));
        this.current.push(data);
    }

    public void visit(AttributeExpression expression) {
    }

    public void visit(Expression expression) {
    }

    public void visit(LiteralExpression expression) {
    }

    public void visit(MathExpression expression) {
    }

    public void visit(FunctionExpression expression) {
    }

    public void visit(IncludeFilter filter) {
        this.current.push(new Data((Filter)filter));
    }

    public void visit(ExcludeFilter filter) {
        this.current.push(new Data((Filter)filter));
    }

    public boolean requiresPostProcessing() {
        return this.requiresPostProcessing;
    }

    private static class Data {
        public static final Data NONE = new Data((Filter)org.geotools.filter.Filter.EXCLUDE);
        public static final Data ALL = new Data((Filter)org.geotools.filter.Filter.INCLUDE);
        final Set fids = new HashSet();
        Filter filter;

        public Data() {
            this(org.geotools.filter.Filter.ALL);
        }

        public Data(Filter f) {
            this.filter = f;
        }

        public Data(org.geotools.filter.Filter f) {
            this.filter = f;
        }

        public String toString() {
            return this.filter + ":" + this.fids;
        }
    }
}

