/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.geonetwork;

import java.util.ArrayList;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.Logger;
import org.gcube.common.geoserverinterface.cxml.CXml;
import org.gcube.common.geoserverinterface.cxml.CXmlManager;
import org.gcube.common.geoserverinterface.geonetwork.GeoserverSortInterface;

public class GeoserverDiscovery {
    private ArrayList<String> wmsGeoserverList = null;
    private ArrayList<String> wfsGeoserverList = null;
    private String mostUnloadWmsGeoserver = null;
    private int indexMostUnloadGeoserver;
    private GeoserverSortInterface sorter = null;
    private String xmlAllHarvestings = null;
    private String xmlWmsHarvestings = null;

    public GeoserverDiscovery(String xmlAllHarvestings) {
        this.loadGeoserverListsByHarvestings(xmlAllHarvestings);
    }

    public ArrayList<String> sortGeoserver(ArrayList<String> list) {
        ArrayList<String> orderList = new ArrayList();
        orderList = this.sorter.sortGeoserverList(list);
        return orderList;
    }

    public GeoserverSortInterface getSorter() {
        return this.sorter;
    }

    public void setSorter(GeoserverSortInterface sorter) {
        this.sorter = sorter;
    }

    private ArrayList<String> loadGeoserverList(GeonetworkCommonResourceInterface.GeoserverType serverType, String xmlHarvestings) {
        final ArrayList<String> list = new ArrayList<String>();
        final String serverTypeLC = serverType.toString().toLowerCase();
        Logger.trace("loadGeoserverList: Parsing Harvestings XML File...\n" + xmlHarvestings);
        CXml root = new CXml(xmlHarvestings);
        root.find("url").each(new CXmlManager(){

            @Override
            public void manage(int index, CXml cXml) {
                String url = cXml.text();
                if (url.endsWith("/" + serverTypeLC)) {
                    url = url.replaceFirst("(/" + serverTypeLC + ")$", "").replaceFirst("(/" + serverTypeLC + "/)$", "");
                    list.add(url);
                }
            }
        });
        return list;
    }

    public void reloadWmsGeoserverList(String xmlWmsHarvestings) {
        this.wmsGeoserverList = this.loadGeoserverList(GeonetworkCommonResourceInterface.GeoserverType.WMS, xmlWmsHarvestings);
    }

    public void reloadWfsGeoserverList(String xmlWfsHarvestings) {
        this.wfsGeoserverList = this.loadGeoserverList(GeonetworkCommonResourceInterface.GeoserverType.WFS, xmlWfsHarvestings);
    }

    public void loadGeoserverListsByHarvestings(String xmlAllHarvestings) {
        this.reloadWmsGeoserverList(xmlAllHarvestings);
        this.reloadWfsGeoserverList(xmlAllHarvestings);
        this.xmlAllHarvestings = xmlAllHarvestings;
    }

    public ArrayList<String> getWmsGeoserverList() {
        return this.wmsGeoserverList;
    }

    public ArrayList<String> getWfsGeoserverList() {
        return this.wfsGeoserverList;
    }
}

