/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.engine;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.gcube.common.geoserverinterface.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;

public class MakeStyle {
    public static String createStyle(String nameStyle, String attributeName, ArrayList<ClassStyleDef> classes, Color c1, Color c2) throws Exception {
        int nClasses = classes.size();
        if (nClasses <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        int nColors = nClasses;
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle();
        style.setName(nameStyle);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<Color> colors = MakeStyle.gradientColor(nColors, c1, c2);
        int color = 0;
        for (ClassStyleDef cls : classes) {
            rules.add(MakeStyle.addRule(sb, attributeName, cls.getTo(), cls.getFrom(), colors.get(color)));
            ++color;
        }
        FeatureTypeStyle fts = sb.createFeatureTypeStyle("Feature", rules.toArray(new Rule[rules.size()]));
        style.featureTypeStyles().add(fts);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        return aTransformer.transform((Object)style);
    }

    public static String createStyle(String nameStyle, String attributeName, int nClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue) throws Exception {
        Number d;
        if (nClasses <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        Double fMax = 0.0;
        Double fMin = 0.0;
        if (maxValue instanceof Integer) {
            fMax = (double)((Integer)maxValue).intValue() * Double.valueOf(1.0);
        }
        if (minValue instanceof Integer) {
            fMin = (double)((Integer)minValue).intValue() * Double.valueOf(1.0);
        }
        if (maxValue instanceof Float) {
            fMax = ((Float)maxValue).doubleValue();
        }
        if (minValue instanceof Float) {
            fMin = ((Float)minValue).doubleValue();
        }
        if (maxValue instanceof Double) {
            fMax = (Double)maxValue * Double.valueOf(1.0);
        }
        if (minValue instanceof Double) {
            fMin = (Double)minValue * Double.valueOf(1.0);
        }
        if (maxValue instanceof String) {
            fMax = Double.parseDouble((String)maxValue);
        }
        if (minValue instanceof String) {
            fMin = Double.parseDouble((String)minValue);
        }
        if (fMax.compareTo(fMin) < 0) {
            throw new Exception("The maximum value must be greater than the minimum value!!");
        }
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle();
        style.setName(nameStyle);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (typeValue == Integer.class) {
            Integer iMin = fMin.intValue();
            Integer iMax = fMax.intValue();
            d = (iMax + 1 - iMin) / nClasses;
            if ((Integer)d == 0) {
                throw new Exception("Too many classes with these values!!");
            }
            Integer start = iMin;
            int nColors = MakeStyle.getColorsNumbers(start, iMax, (Integer)d);
            ArrayList<Color> colors = MakeStyle.gradientColor(nColors, c1, c2);
            if ((Integer)d == 1) {
                int color = 0;
                while (start <= iMax) {
                    rules.add(MakeStyle.addRule(sb, attributeName, start, colors.get(color)));
                    start = start + (Integer)d;
                    ++color;
                }
            } else {
                int color = 0;
                while (start <= iMax) {
                    if (start == iMax) {
                        rules.add(MakeStyle.addRule(sb, attributeName, start, colors.get(color)));
                    } else {
                        rules.add(MakeStyle.addRule(sb, attributeName, start + (Integer)d, start, colors.get(color)));
                    }
                    start = start + (Integer)d;
                    ++color;
                }
            }
        } else {
            float floatMin;
            Logger.debug("---Doubles: " + fMax + " - " + fMin);
            float floatMax = fMax.floatValue();
            if ((double)floatMax > fMax) {
                fMax = floatMax;
            }
            if ((double)(floatMin = fMin.floatValue()) < fMin) {
                fMin = floatMin;
            }
            Logger.debug("---Floats: " + floatMax + " - " + floatMin);
            fMax = Math.ceil(fMax * 100.0) / 100.0;
            fMin = Math.floor(fMin * 100.0) / 100.0;
            Logger.debug("---RE-Doubles: " + fMax + " - " + fMin);
            d = (fMax - fMin) / (double)nClasses;
            d = Math.floor((Double)d * 100.0) / 100.0;
            if ((Double)d == 0.0) {
                throw new Exception("Too many classes with these values!!");
            }
            Double start = fMin;
            int nColors = MakeStyle.getColorsNumbers(start, fMax, (Double)d);
            ArrayList<Color> colors = MakeStyle.gradientColor(nColors, c1, c2);
            if ((Double)d == 1.0) {
                int color = 0;
                Logger.debug("---d==1");
                while (start.compareTo(fMax) <= 0) {
                    rules.add(MakeStyle.addRule(sb, attributeName, start, colors.get(color)));
                    start = start + (Double)d;
                    ++color;
                }
            } else {
                Logger.debug("---d!=1");
                int color = 0;
                while (start.compareTo(fMax) <= 0) {
                    if (start.compareTo(fMax) == 0) {
                        rules.add(MakeStyle.addRule(sb, attributeName, start, colors.get(color)));
                    } else {
                        rules.add(MakeStyle.addRule(sb, attributeName, start + (Double)d, start, colors.get(color)));
                    }
                    start = start + (Double)d;
                    ++color;
                }
            }
        }
        FeatureTypeStyle fts = sb.createFeatureTypeStyle("Feature", rules.toArray(new Rule[rules.size()]));
        style.featureTypeStyles().add(fts);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        String out = aTransformer.transform((Object)style);
        Logger.debug("---done!");
        return out;
    }

    public static String createStyleScatterColors(String nameStyle, String attributeName, int nClasses, Class typeValue, Object maxValue, Object minValue) throws Exception {
        Number d;
        if (nClasses <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        Double fMax = 0.0;
        Double fMin = 0.0;
        if (maxValue instanceof Integer) {
            fMax = (double)((Integer)maxValue).intValue() * Double.valueOf(1.0);
        }
        if (minValue instanceof Integer) {
            fMin = (double)((Integer)minValue).intValue() * Double.valueOf(1.0);
        }
        if (maxValue instanceof Float) {
            fMax = ((Float)maxValue).doubleValue();
        }
        if (minValue instanceof Float) {
            fMin = ((Float)minValue).doubleValue();
        }
        if (maxValue instanceof Double) {
            fMax = (Double)maxValue * Double.valueOf(1.0);
        }
        if (minValue instanceof Double) {
            fMin = (Double)minValue * Double.valueOf(1.0);
        }
        if (maxValue instanceof String) {
            fMax = Double.parseDouble((String)maxValue);
        }
        if (minValue instanceof String) {
            fMin = Double.parseDouble((String)minValue);
        }
        if (fMax.compareTo(fMin) < 0) {
            throw new Exception("The maximum value must be greater than the minimum value!!");
        }
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle();
        style.setName(nameStyle);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (typeValue == Integer.class) {
            Integer iMin = fMin.intValue();
            Integer iMax = fMax.intValue();
            d = (iMax + 1 - iMin) / nClasses;
            if ((Integer)d == 0) {
                throw new Exception("Too many classes with these values!!");
            }
            Integer start = iMin;
            int nColors = MakeStyle.getColorsNumbers(start, iMax, (Integer)d);
            ArrayList<Color> colors = MakeStyle.scatterColor(nColors);
            if ((Integer)d == 1) {
                int color = 0;
                while (start <= iMax) {
                    rules.add(MakeStyle.addRule(sb, attributeName, start, colors.get(color)));
                    start = start + (Integer)d;
                    ++color;
                }
            } else {
                int color = 0;
                while (start <= iMax) {
                    if (start == iMax) {
                        rules.add(MakeStyle.addRule(sb, attributeName, start, colors.get(color)));
                    } else {
                        rules.add(MakeStyle.addRule(sb, attributeName, start + (Integer)d, start, colors.get(color)));
                    }
                    start = start + (Integer)d;
                    ++color;
                }
            }
        } else {
            float floatMin;
            Logger.debug("---Doubles: " + fMax + " - " + fMin);
            float floatMax = fMax.floatValue();
            if ((double)floatMax > fMax) {
                fMax = floatMax;
            }
            if ((double)(floatMin = fMin.floatValue()) < fMin) {
                fMin = floatMin;
            }
            Logger.debug("---Floats: " + floatMax + " - " + floatMin);
            fMax = Math.ceil(fMax * 100.0) / 100.0;
            fMin = Math.floor(fMin * 100.0) / 100.0;
            Logger.debug("---RE-Doubles: " + fMax + " - " + fMin);
            d = (fMax - fMin) / (double)nClasses;
            d = Math.floor((Double)d * 100.0) / 100.0;
            if ((Double)d == 0.0) {
                throw new Exception("Too many classes with these values!!");
            }
            Double start = fMin;
            int nColors = MakeStyle.getColorsNumbers(start, fMax, (Double)d);
            ArrayList<Color> colors = MakeStyle.scatterColor(nColors);
            if ((Double)d == 1.0) {
                int color = 0;
                Logger.debug("---d==1");
                while (start.compareTo(fMax) <= 0) {
                    rules.add(MakeStyle.addRule(sb, attributeName, start, colors.get(color)));
                    start = start + (Double)d;
                    ++color;
                }
            } else {
                Logger.debug("---d!=1");
                int color = 0;
                while (start.compareTo(fMax) <= 0) {
                    if (start.compareTo(fMax) == 0) {
                        rules.add(MakeStyle.addRule(sb, attributeName, start, colors.get(color)));
                    } else {
                        rules.add(MakeStyle.addRule(sb, attributeName, start + (Double)d, start, colors.get(color)));
                    }
                    start = start + (Double)d;
                    ++color;
                }
            }
        }
        FeatureTypeStyle fts = sb.createFeatureTypeStyle("Feature", rules.toArray(new Rule[rules.size()]));
        style.featureTypeStyles().add(fts);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        String out = aTransformer.transform((Object)style);
        Logger.debug("---done!");
        return out;
    }

    public static String createStyleLog(String nameStyle, String attributeName, int nClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue) throws Exception {
        if (nClasses <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        Float fMax = Float.valueOf(0.0f);
        Float fMin = Float.valueOf(0.0f);
        if (maxValue instanceof Integer) {
            fMax = Float.valueOf((float)((Integer)maxValue).intValue() * 1.0f);
        }
        if (minValue instanceof Integer) {
            fMin = Float.valueOf((float)((Integer)minValue).intValue() * 1.0f);
        }
        if (maxValue instanceof Float) {
            fMax = (Float)maxValue;
        }
        if (minValue instanceof Float) {
            fMin = (Float)minValue;
        }
        if (maxValue instanceof Double) {
            fMax = Float.valueOf((float)((Double)maxValue * 1.0));
        }
        if (minValue instanceof Double) {
            fMin = Float.valueOf((float)((Double)minValue * 1.0));
        }
        if (maxValue instanceof String) {
            fMax = Float.valueOf(Float.parseFloat((String)maxValue));
        }
        if (minValue instanceof String) {
            fMin = Float.valueOf(Float.parseFloat((String)minValue));
        }
        if (fMax.compareTo(fMin) < 0) {
            throw new Exception("The maximum value must be greater than the minimum value!!");
        }
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle();
        style.setName(nameStyle);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (typeValue == Integer.class) {
            Integer iMin = fMin.intValue();
            Integer iMax = fMax.intValue();
            int startLog = iMin <= 0 ? 1 : iMin;
            Double[] intervals = MakeStyle.logSubdivision(startLog, iMax.intValue(), nClasses);
            ArrayList<Color> colors = MakeStyle.gradientColor(intervals.length, c1, c2);
            int color = 0;
            if (intervals.length <= 0) {
                throw new Exception("Invalid interval!!");
            }
            if (intervals.length == 1) {
                intervals[0] = (double)iMin.intValue() * 1.0;
                rules.add(MakeStyle.addRule(sb, attributeName, intervals[0].intValue(), colors.get(color)));
            } else {
                intervals[0] = (double)iMin.intValue() * 1.0;
                for (int i = 0; i < intervals.length - 1; ++i) {
                    rules.add(MakeStyle.addRule(sb, attributeName, intervals[i + 1].intValue(), intervals[i].intValue(), colors.get(color)));
                    ++color;
                }
            }
        } else {
            float startLog = fMin.floatValue() <= 0.0f ? 1.0f : fMin.floatValue();
            Double[] intervals = MakeStyle.logSubdivision(startLog, fMax.floatValue(), nClasses);
            ArrayList<Color> colors = MakeStyle.gradientColor(intervals.length, c1, c2);
            int color = 0;
            if (intervals.length <= 0) {
                throw new Exception("Invalid interval!!");
            }
            if (intervals.length == 1) {
                intervals[0] = (double)fMin.floatValue() * 1.0;
                rules.add(MakeStyle.addRule(sb, attributeName, MakeStyle.round(intervals[0], 3), colors.get(color)));
            } else {
                intervals[0] = (double)fMin.floatValue() * 1.0;
                for (int i = 0; i < intervals.length - 1; ++i) {
                    rules.add(MakeStyle.addRule(sb, attributeName, MakeStyle.round(intervals[i + 1], 3), MakeStyle.round(intervals[i], 3), colors.get(color)));
                    ++color;
                }
            }
        }
        FeatureTypeStyle fts = sb.createFeatureTypeStyle("Feature", rules.toArray(new Rule[rules.size()]));
        style.featureTypeStyles().add(fts);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        return aTransformer.transform((Object)style);
    }

    private static Double[] logSubdivision(double start, double end, int numberOfParts) {
        if (end <= start) {
            return null;
        }
        double logStart = Math.log(start);
        double logEnd = Math.log(end);
        double difference = logEnd - logStart;
        double step = 0.0;
        if (numberOfParts > 0) {
            step = difference / (double)numberOfParts;
        }
        Double[] linearpoints = new Double[numberOfParts + 1];
        for (int i = 0; i < numberOfParts + 1; ++i) {
            linearpoints[i] = Math.exp(logStart + (double)i * step);
            if (!(linearpoints[i] < 0.011)) continue;
            linearpoints[i] = 0.0;
        }
        return linearpoints;
    }

    private static int getColorsNumbers(Integer start, Integer iMax, Integer d) {
        int color = 0;
        while (start <= iMax) {
            start = start + d;
            ++color;
        }
        return color;
    }

    private static int getColorsNumbers(Double start, Double fMax, Double d) {
        int color = 0;
        int i = 0;
        while (start <= fMax) {
            double s = start + d;
            start = s;
            ++color;
            if (++i <= 50) continue;
            break;
        }
        return color;
    }

    private static Rule addRule(StyleBuilder sb, String attributeName, Object lessThe, Object greater, Color fillColor) {
        PolygonSymbolizer polygonSymbolizer = sb.createPolygonSymbolizer(fillColor);
        Rule rule = sb.createRule((Symbolizer)polygonSymbolizer);
        if (greater instanceof Double || greater instanceof Float) {
            greater = MakeStyle.roundDecimal(((Number)greater).doubleValue(), 2);
        }
        if (lessThe instanceof Double || lessThe instanceof Float) {
            lessThe = MakeStyle.roundDecimal(((Number)lessThe).doubleValue(), 2);
        }
        rule.setTitle(">= " + greater + " - < " + lessThe);
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
        PropertyIsGreaterThanOrEqualTo filterThen = filterFactory.greaterOrEqual((Expression)filterFactory.property(attributeName), (Expression)filterFactory.literal(greater), true);
        PropertyIsLessThan filterElse = filterFactory.less((Expression)filterFactory.property(attributeName), (Expression)filterFactory.literal(lessThe));
        And filter = filterFactory.and((Filter)filterThen, (Filter)filterElse);
        rule.setFilter((Filter)filter);
        return rule;
    }

    private static Rule addRule(StyleBuilder sb, String attributeName, Object equal, Color fillColor) {
        PolygonSymbolizer polygonSymbolizer = sb.createPolygonSymbolizer(fillColor);
        Rule rule = sb.createRule((Symbolizer)polygonSymbolizer);
        if (equal instanceof Double) {
            equal = MakeStyle.roundDecimal((Double)equal, 2);
        }
        rule.setTitle("=" + equal);
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
        PropertyIsEqualTo filter = filterFactory.equal((Expression)filterFactory.property(attributeName), (Expression)filterFactory.literal(equal), true);
        rule.setFilter((Filter)filter);
        return rule;
    }

    private static ArrayList<Color> gradientColor(int nColors, Color c1, Color c2) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int i = 0; i < nColors; ++i) {
            float ratio = (float)i / (float)nColors;
            int red = (int)((float)c2.getRed() * ratio + (float)c1.getRed() * (1.0f - ratio));
            int green = (int)((float)c2.getGreen() * ratio + (float)c1.getGreen() * (1.0f - ratio));
            int blue = (int)((float)c2.getBlue() * ratio + (float)c1.getBlue() * (1.0f - ratio));
            colors.add(new Color(red, green, blue));
        }
        return colors;
    }

    public static ArrayList<Color> scatterColor(int nColors) {
        ArrayList<Color> colors = new ArrayList<Color>();
        float saturation = 1.0f;
        float brightness = 1.0f;
        for (int i = 0; i < nColors; ++i) {
            float ratio = (float)i * 1.5f / (float)nColors;
            if (i % 10 == 0) {
                brightness = (float)Math.max(0.1, (double)brightness - 0.1);
            }
            int rgb = Color.HSBtoRGB(ratio, brightness, saturation);
            Color color = new Color(rgb);
            colors.add(color);
        }
        return colors;
    }

    public static int HexToR(String h) {
        return Integer.parseInt(MakeStyle.cutHex(h).substring(0, 2), 16);
    }

    public static int HexToG(String h) {
        return Integer.parseInt(MakeStyle.cutHex(h).substring(2, 4), 16);
    }

    public static int HexToB(String h) {
        return Integer.parseInt(MakeStyle.cutHex(h).substring(4, 6), 16);
    }

    public static String cutHex(String h) {
        return h.substring(0, 1).contentEquals("#") ? h.substring(1) : h;
    }

    public static double round(double d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(Double.toString(d));
        bd = bd.setScale(decimalPlace, 4);
        return bd.doubleValue();
    }

    public static double roundDecimal(double number, int decimalposition) {
        double n = (double)Math.round(number * Math.pow(10.0, decimalposition)) / Math.pow(10.0, decimalposition);
        return n;
    }

    public class ClassStyleDef {
        Object from = 0;
        Object to = 0;

        public ClassStyleDef() {
        }

        public ClassStyleDef(Object from, Object to) {
            this.from = from;
            this.to = to;
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }

        public void setFrom(Object from) {
            this.from = from;
        }

        public void setTo(Object to) {
            this.to = to;
        }
    }
}

