package org.gcube.common.gxrest.request;

import org.gcube.common.gxrest.response.inbound.GXInboundResponse;

/**
 * HTTP methods for requests.
 * 
 * @author Manuele Simi (ISTI CNR)
 *
 */
interface GXHTTP {
	
	/**
	 * Sends the PUT request to the web application.
	 * @return the response
	 */
	GXInboundResponse put() throws Exception;
	
	/**
	 * Sends the DELETE request to the web application.
	 * @return the response
	 */
	GXInboundResponse delete() throws Exception;
	
	/**
	 * Sends the HEAD request to the web application.
	 * @return the response
	 */
	GXInboundResponse head() throws Exception;
	
	/**
	 * Sends the GET request to the web application.
	 * @return the response
	 */
	GXInboundResponse get() throws Exception;

	/**
	 * Sends the POST request to the web application.
	 * @return the response
	 * @throws Exception
	 */
	GXInboundResponse post() throws Exception;

}
