/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.response.inbound;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.io.IOUtils;

public final class ContentUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Object obj) throws IOException {
        byte[] bytes = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T toObject(InputStream inputStream, Class<T> class1) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        Object o = null;
        try {
            in = new ObjectInputStream(inputStream);
            o = in.readObject();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (T)o;
    }

    public Object toObject(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ObjectInputStream is = new ObjectInputStream(in);
        return is.readObject();
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    public static String toString(byte[] bytes) {
        return new String(bytes);
    }

    public static <T> T fromJson(byte[] bytes, Class<T> raw) throws Exception {
        try {
            Gson gson = new Gson();
            return (T)gson.fromJson(ContentUtils.toString(bytes), raw);
        }
        catch (JsonSyntaxException jse) {
            throw new Exception("Cannot deserialize to the object.");
        }
    }

    public static <T> T fromJson(String json, Class<T> raw) throws Exception {
        try {
            Gson gson = new Gson();
            return (T)gson.fromJson(json, raw);
        }
        catch (JsonSyntaxException jse) {
            throw new Exception("Cannot deserialize to the object.");
        }
    }
}

