/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.request;

import java.io.InputStream;
import java.util.Objects;
import org.gcube.common.gxrest.request.GXConnection;
import org.gcube.common.gxrest.request.GXHTTP;
import org.gcube.common.gxrest.request.GXHTTPCommon;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;

public class GXHTTPStreamRequest
extends GXHTTPCommon<GXHTTPStreamRequest>
implements GXHTTP<InputStream> {
    private GXHTTPStreamRequest(String address) {
        this.connection = new GXConnection(address);
    }

    public static GXHTTPStreamRequest newRequest(String address) {
        return new GXHTTPStreamRequest(address);
    }

    @Override
    public GXInboundResponse put(InputStream body) throws Exception {
        if (Objects.nonNull(body)) {
            this.connection.addBodyAsStream(body);
        }
        logger.trace("Sending a PUT request...");
        return this.connection.send(GXConnection.HTTPMETHOD.PUT);
    }

    @Override
    public GXInboundResponse post(InputStream body) throws Exception {
        logger.trace("Sending a POST request...");
        if (Objects.nonNull(body)) {
            this.connection.addBodyAsStream(body);
        }
        return this.connection.send(GXConnection.HTTPMETHOD.POST);
    }
}

