/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.h2;

import java.util.HashMap;
import java.util.Map;
import org.gcube.common.dbinterface.builders.Builders;
import org.gcube.common.dbinterface.queries.GetMetadata;
import org.gcube.common.dbinterface.registry.DBInterface;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.dbinterface.h2.builders.BuildersImpl;
import org.gcube.dbinterface.h2.query.GetMetadataImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBInterfaceImpl
extends DBInterface {
    private static final Logger logger = LoggerFactory.getLogger(DBInterfaceImpl.class);
    Map<Type.InnerType, String[]> typeMapping;

    public void initialise() {
        logger.debug("initialisation method called");
        this.typeMapping = new HashMap<Type.InnerType, String[]>();
        this.typeMapping.put(Type.InnerType.INTEGER, new String[]{"integer", "int", "numeric", "int4", "serial"});
        this.typeMapping.put(Type.InnerType.STRING, new String[]{"character varying", "varchar"});
        this.typeMapping.put(Type.InnerType.TEXT, new String[]{"text", "clob"});
        this.typeMapping.put(Type.InnerType.FLOAT, new String[]{"decimal", "double precision", "bigdecimal", "float4", "real"});
        this.typeMapping.put(Type.InnerType.LONG, new String[]{"bigint"});
        this.typeMapping.put(Type.InnerType.DATE, new String[]{"date"});
        this.typeMapping.put(Type.InnerType.TIME, new String[]{"time"});
        this.typeMapping.put(Type.InnerType.TIMESTAMP, new String[]{"timestamp", "timestamp without time zone"});
        this.typeMapping.put(Type.InnerType.BOOLEAN, new String[]{"boolean", "bool"});
        logger.debug("initialisation method finished");
    }

    public Builders builders() {
        return BuildersImpl.get();
    }

    public Map<Type.InnerType, String[]> getTypeMapping() {
        return this.typeMapping;
    }

    public String getDrivers() {
        return "org.h2.Driver";
    }

    public GetMetadata getMetadata(Table table) {
        return new GetMetadataImpl(table);
    }
}

