/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.h2.query;

import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;

public class SelectImpl
extends Select {
    private String expression = "SELECT <%DISTINCT%> <%ATTRIBUTES%> <%TABLE%> <%WHERE%> <%GROUPBY%> <%ORDER%> <%LIMIT%>  ";

    public String getQuery() {
        return this.getExpression();
    }

    protected String getExpression() {
        String tmpExpression = new String(this.expression);
        tmpExpression = tmpExpression.replaceAll("<%DISTINCT%>", this._getDistinct());
        tmpExpression = tmpExpression.replaceAll("<%WHERE%>", this._getFilters());
        tmpExpression = tmpExpression.replaceAll("<%GROUPBY%>", this._getGroups());
        tmpExpression = tmpExpression.replaceAll("<%ATTRIBUTES%>", this._getAttributes());
        tmpExpression = tmpExpression.replaceAll("<%ORDER%>", this._getOrders());
        tmpExpression = tmpExpression.replaceAll("<%TABLE%>", this._getTables());
        tmpExpression = tmpExpression.replaceAll("<%LIMIT%>", this._getLimits());
        return tmpExpression;
    }

    protected String _getAttributes() {
        if (this.getAttributes() == null || this.getAttributes().size() == 0) {
            return "*";
        }
        String tmpAttributes = "";
        for (Attribute attribute : this.getAttributes()) {
            tmpAttributes = String.valueOf(tmpAttributes) + attribute.getAttribute() + ",";
        }
        return tmpAttributes.substring(0, tmpAttributes.length() - 1);
    }

    protected String _getFilters() {
        if (this.getCondition() == null) {
            return "";
        }
        return "WHERE " + this.getCondition().getCondition();
    }

    protected String _getOrders() {
        String tmpOrder = " ";
        if (this.getOrderBy() == null || this.getOrderBy().size() == 0) {
            return "";
        }
        tmpOrder = "ORDER BY ";
        for (Order order : this.getOrderBy()) {
            tmpOrder = String.valueOf(tmpOrder) + order.getOrder() + ",";
        }
        return tmpOrder.substring(0, tmpOrder.length() - 1);
    }

    protected String _getTables() {
        if (this.getTables() == null || this.getTables().size() == 0) {
            return "";
        }
        String tmpTables = " FROM ";
        for (Table table : this.getTables()) {
            tmpTables = String.valueOf(tmpTables) + table.getTable() + ",";
        }
        return tmpTables.substring(0, tmpTables.length() - 1);
    }

    protected String _getLimits() {
        if (this.getLimit() == null) {
            return "";
        }
        return this.getLimit().getLimits();
    }

    protected String _getGroups() {
        if (this.getGroupBy() == null || this.getGroupBy().size() == 0) {
            return "";
        }
        String tmpGroups = "GROUP BY ";
        for (Attribute attrib : this.getGroupBy()) {
            tmpGroups = String.valueOf(tmpGroups) + attrib.getAttribute() + ",";
        }
        return tmpGroups.substring(0, tmpGroups.length() - 1);
    }

    protected String _getDistinct() {
        return this.isUseDistinct() ? "DISTINCT" : "";
    }
}

