/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.h2.query;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.gcube.common.dbinterface.queries.GetMetadata;
import org.gcube.common.dbinterface.registry.Connection;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetMetadataImpl
extends GetMetadata {
    private static final Logger logger = LoggerFactory.getLogger(GetMetadataImpl.class);

    public GetMetadataImpl(Table table) {
        super(table);
    }

    public LinkedHashMap<String, Type> getMetadata(Connection conn) throws Exception {
        System.out.println("calling getMetadata for table " + this.getTable().getTableName() + "---------------------");
        ResultSet result = conn.getDBMetadata().getColumns(null, null, this.getTable().getTableName().toUpperCase(), null);
        ArrayList<String> primaryKeyList = new ArrayList<String>(2);
        try {
            ResultSet primaryKeyRS = conn.getDBMetadata().getPrimaryKeys(null, null, this.getTable().getTableName().toUpperCase());
            while (primaryKeyRS.next()) {
                primaryKeyList.add(primaryKeyRS.getString("column_name"));
            }
        }
        catch (Exception e) {
            logger.trace("no prymary keys found for " + this.getTable().getTableName());
            System.out.println("no prymary keys found for " + this.getTable().getTableName());
        }
        LinkedHashMap<String, Type> tempMapping = new LinkedHashMap<String, Type>();
        while (result.next()) {
            logger.trace("fieldId: " + result.getString("COLUMN_NAME") + "  and the type is " + result.getInt("COLUMN_SIZE") + " " + result.getString("TYPE_NAME") + "  " + result.getInt("NUM_PREC_RADIX") + "   " + result.getInt("DECIMAL_DIGITS"));
            String typeName = result.getString("TYPE_NAME").equals("numeric") && result.getInt("DECIMAL_DIGITS") > 0 ? "decimal" : result.getString("TYPE_NAME");
            Type tmpType = Type.parseType((String)typeName, (int)result.getInt("COLUMN_SIZE"), (int)result.getInt("COLUMN_SIZE"), (int)result.getInt("DECIMAL_DIGITS"));
            try {
                if (result.getString("COLUMN_DEF") != null && result.getString("COLUMN_DEF").contains("nextval")) {
                    tmpType.setAutoincrement(true);
                }
            }
            catch (Exception e) {
                tmpType.setAutoincrement(false);
            }
            if (primaryKeyList.contains(result.getString("COLUMN_NAME"))) {
                tmpType.setPrimaryKey(true);
            }
            tempMapping.put(result.getString("COLUMN_NAME").toLowerCase(), tmpType);
        }
        return tempMapping;
    }
}

