/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.id;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.id.AbstractCompositeIdMapper;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedIdMapper
extends AbstractCompositeIdMapper
implements SimpleIdMapperBuilder {
    private PropertyData idPropertyData;

    public EmbeddedIdMapper(PropertyData idPropertyData, String compositeIdClass) {
        super(compositeIdClass);
        this.idPropertyData = idPropertyData;
    }

    @Override
    public void mapToMapFromId(Map<String, Object> data, Object obj) {
        for (SingleIdMapper idMapper : this.ids.values()) {
            idMapper.mapToMapFromEntity(data, obj);
        }
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        if (obj == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.idPropertyData);
        this.mapToMapFromId(data, getter.get(obj));
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data) {
        if (data == null || obj == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.idPropertyData);
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.idPropertyData);
        try {
            Object subObj = ReflectHelper.getDefaultConstructor(getter.getReturnType()).newInstance(new Object[0]);
            setter.set(obj, subObj, null);
            for (SingleIdMapper idMapper : this.ids.values()) {
                idMapper.mapToEntityFromMap(subObj, data);
            }
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
    }

    @Override
    public IdMapper prefixMappedProperties(String prefix) {
        EmbeddedIdMapper ret = new EmbeddedIdMapper(this.idPropertyData, this.compositeIdClass);
        for (PropertyData propertyData : this.ids.keySet()) {
            String propertyName = propertyData.getName();
            ret.ids.put(propertyData, new SingleIdMapper(new PropertyData(prefix + propertyName, propertyData)));
        }
        return ret;
    }

    @Override
    public Object mapToIdFromEntity(Object data) {
        if (data == null) {
            return null;
        }
        Getter getter = ReflectionTools.getGetter(data.getClass(), this.idPropertyData);
        return getter.get(data);
    }

    @Override
    public List<QueryParameterData> mapToQueryParametersFromId(Object obj) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        this.mapToMapFromId(data, obj);
        ArrayList<QueryParameterData> ret = new ArrayList<QueryParameterData>();
        for (Map.Entry propertyData : data.entrySet()) {
            ret.add(new QueryParameterData((String)propertyData.getKey(), propertyData.getValue()));
        }
        return ret;
    }
}

