/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import org.hibernate.Hibernate;
import org.hibernate.QueryException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.LiteralNode;
import org.hibernate.type.LiteralType;
import org.hibernate.type.Type;

public class BooleanLiteralNode
extends LiteralNode
implements ExpectedTypeAwareNode {
    private Type expectedType;

    public Type getDataType() {
        return this.expectedType == null ? Hibernate.BOOLEAN : this.expectedType;
    }

    public Boolean getValue() {
        return this.getType() == 49 ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setExpectedType(Type expectedType) {
        this.expectedType = expectedType;
    }

    public Type getExpectedType() {
        return this.expectedType;
    }

    public String getRenderText(SessionFactoryImplementor sessionFactory) {
        try {
            return this.typeAsLiteralType().objectToSQLString(this.getValue(), sessionFactory.getDialect());
        }
        catch (Throwable t) {
            throw new QueryException("Unable to render boolean literal value", t);
        }
    }

    private LiteralType typeAsLiteralType() {
        return (LiteralType)((Object)this.getDataType());
    }
}

