/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.impl.AbstractAuditQuery;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.query.QueryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntitiesAtRevisionQuery
extends AbstractAuditQuery {
    private final Number revision;

    public EntitiesAtRevisionQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls, Number revision) {
        super(verCfg, versionsReader, cls);
        this.revision = revision;
    }

    @Override
    public List list() {
        QueryBuilder maxRevQb = this.qb.newSubQueryBuilder(this.versionsEntityName, "e2");
        AuditEntitiesConfiguration verEntCfg = this.verCfg.getAuditEntCfg();
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
        maxRevQb.addProjection("max", revisionPropertyPath, false);
        maxRevQb.getRootParameters().addWhereWithParam(revisionPropertyPath, "<=", this.revision);
        this.verCfg.getEntCfg().get(this.entityName).getIdMapper().addIdsEqualToQuery(maxRevQb.getRootParameters(), "e." + originalIdPropertyName, "e2." + originalIdPropertyName);
        this.qb.getRootParameters().addWhereWithParam(verEntCfg.getRevisionTypePropName(), "<>", (Object)RevisionType.DEL);
        this.qb.getRootParameters().addWhere(revisionPropertyPath, this.verCfg.getGlobalCfg().getCorrelatedSubqueryOperator(), maxRevQb);
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.verCfg, this.entityName, this.qb, this.qb.getRootParameters());
        }
        List queryResult = this.buildAndExecuteQuery();
        if (this.hasProjection) {
            return queryResult;
        }
        ArrayList result = new ArrayList();
        this.entityInstantiator.addInstancesFromVersionsEntities(this.entityName, result, queryResult, this.revision);
        return result;
    }
}

