package org.gcube.common.homelibrary.client;

import java.util.List;
import java.util.UUID;

import org.gcube.common.homelibrary.client.servlet.Servlets;
import org.gcube.common.homelibrary.client.util.Config;

public class Test {

	public Test (){

		try {
			//list default folder
			System.out.println("List Folder /");

			List<String> list = Servlets.listFolder(Config.ROOT_PATH);
			System.out.println(list.size() + " elements found \n");

			for(String child:list){
				System.out.println(child);
			}
			System.out.println("\n\n");

			//create folder
			String folderPath = Servlets.createFolder("myFolder-"+ UUID.randomUUID().toString(), "my test folder", Config.ROOT_PATH);
			System.out.println(folderPath.replace(Config.ROOT_PATH, "") + " created in " +  Config.ROOT_PATH.replace(Config.ROOT_PATH, "/") +" \n\n");

			//save images
			System.out.println("Save images in " + folderPath.replace(Config.ROOT_PATH, ""));
			
//			URL imageURL = Test.class.getClassLoader().getResource(Config.DEFAULT_IMAGE);
//			for (int i= 0; i< 5; i++){
//				String image = Servlets.save(imageURL.getFile(), "img-"+ UUID.randomUUID().toString()+".jpg", "my description", folderPath);
//				System.out.println(image);
//			}

			System.out.println("\n\n");

			//list new folder
			System.out.println("List Folder " + Config.ROOT_PATH.replace(Config.ROOT_PATH, "/"));
			List<String> children = Servlets.listFolder(folderPath);
			System.out.println(children.size() + " elements found \n");

			for(String child:children){
				System.out.println(child.replace(Config.ROOT_PATH, ""));
			}
			System.out.println("\n\n");

			//Delete new folder
			Boolean flag = Servlets.delete(folderPath);
			if (flag)
				System.out.println(folderPath.replace(Config.ROOT_PATH, "") + " deleted.");
			else
				System.out.println(folderPath.replace(Config.ROOT_PATH, "") + " cannot be deleted.");


			System.out.println("\n\n");

			System.out.println("HL CLI test successfully completed. ");

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}

