/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.client;

import java.io.File;
import java.net.URL;
import java.util.UUID;
import org.gcube.common.homelibrary.client.FTPClient;
import org.gcube.common.homelibrary.client.FTPFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JUnitTest {
    FTPClient client;

    @Before
    public void initMethod() throws Exception {
        FTPFile[] list;
        this.client = new FTPClient();
        System.out.println("Current dir " + this.client.currentDirectory());
        System.out.println("List Root ");
        for (FTPFile item : list = this.client.list()) {
            System.out.println("* " + item.getName() + " is folder? " + item.isFolder());
        }
        System.out.println("\n\n");
    }

    @Test
    public void test() throws Exception {
        String A_name = "A-" + UUID.randomUUID().toString();
        String B_name = "B-" + UUID.randomUUID().toString();
        this.client.createDirectory(A_name, "test A in ROOT");
        System.out.println("Folder " + A_name + " created in " + this.client.currentDirectory());
        this.client.changeDirectory(A_name);
        System.out.println("Current dir " + this.client.currentDirectory());
        Assert.assertEquals((Object)this.client.currentDirectory(), (Object)("/Share/042efb85-240b-4a04-93d3-bca3924b7503/" + A_name));
        System.out.println("\n\n");
        this.client.createDirectory(B_name, "test A in ROOT");
        System.out.println("Folder " + B_name + " created in " + this.client.currentDirectory());
        this.client.changeDirectory(B_name);
        System.out.println("Current dir " + this.client.currentDirectory());
        Assert.assertEquals((Object)this.client.currentDirectory(), (Object)("/Share/042efb85-240b-4a04-93d3-bca3924b7503/" + A_name + "/" + B_name));
        System.out.println("\n\n");
        System.out.println("Save images in " + this.client.currentDirectory());
        URL imageURL = JUnitTest.class.getClassLoader().getResource("default.jpg");
        for (int i = 0; i < 5; ++i) {
            this.client.upload(new File(imageURL.getFile()), "img-" + UUID.randomUUID().toString() + ".jpg", "my description");
        }
        System.out.println("\n\n");
        this.client.changeDirectoryUp();
        System.out.println("Current directory up " + this.client.currentDirectory());
        Assert.assertEquals((Object)this.client.currentDirectory(), (Object)("/Share/042efb85-240b-4a04-93d3-bca3924b7503/" + A_name));
        System.out.println("Delete folder " + B_name);
        this.client.deleteDirectory(B_name);
        System.out.println("\n\n");
        this.client.changeDirectoryUp();
        Assert.assertEquals((Object)this.client.currentDirectory(), (Object)"/Share/042efb85-240b-4a04-93d3-bca3924b7503");
        System.out.println("Current directory " + this.client.currentDirectory());
        System.out.println("Delete folder " + A_name);
        this.client.deleteDirectory(A_name);
        System.out.println("\n\n");
        System.out.println("HL CLI test successfully completed. ");
    }

    @After
    public void endMethod() throws Exception {
    }
}

