/**
 * 
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryCreate;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryType;

/**
 * @author Antonio Gioia antonio.gioia@isti.cnr.it
 *
 */
public class JCRAccountingEntryCreate extends JCRAccountingEntry implements AccountingEntryCreate {
	
	private static String ITEM_NAME 			= "hl:itemName";
	
	protected String itemName;
	/**
	 * @param node
	 * @throws RepositoryException
	 */
	public JCRAccountingEntryCreate(Node node) throws RepositoryException {
		super(node);
		this.itemName = node.getProperty(ITEM_NAME).getString();

	}
	
	public JCRAccountingEntryCreate(String user, Calendar date, String itemName) {
		super(user,date);
	}

	@Override
	public AccountingEntryType getEntryType() {
		return AccountingEntryType.CREATE;
	}
	
	@Override
	public String toString() {
		String parentValue = super.toString();
		return String.format("[%s [%s]]",parentValue, getEntryType());
	}
	
	@Override
	public void save(Node entryNode) throws RepositoryException {
		super.save(entryNode);
		
		entryNode.setProperty(ITEM_NAME, itemName);
	}
	
	public String getItemName() {		
		return itemName;
	}

}
