package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import ij.ImagePlus;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;

import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.items.Image;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.util.WorkspaceItemUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRImage extends JCRFile implements Image {

	private static final String IMAGE_WIDTH 		= "hl:width";
	private static final String IMAGE_HEIGHT 		= "hl:height";
	private static final String THUMBNAIL_DATA 		= "hl:thumbnailData";
	private static final String THUMBNAIL_WIDTH 	= "hl:thumbnailWidth";
	private static final String THUMBNAIL_HEIGHT 	= "hl:thumbnailHeight";
	private static final String noPreviewImg 		= "/no-thumbnail.png";


	public JCRImage(JCRWorkspace workspace, Node node) throws RepositoryException  {
		super(workspace, node);

	}

	public JCRImage(JCRWorkspace workspace, Node node, InputStream data)throws RepositoryException, IOException, RemoteBackendException{		
		super(workspace, node, new BufferedInputStream(data));
		setProperties(node);

	}


	private void setProperties(Node node) throws IOException, ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {

		//		String remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();

		InputStream dataImage = null;
		int[] thumbnailSize = null;
		InputStream thumbnailStream = null;
		ImagePlus imagePlus = null;
		int width = 0;
		int height = 0;

		try{

			dataImage = new FileInputStream(tmpFile);  
			//			dataImage = GCUBEStorage.getRemoteFile(remotePath, portalLogin);

			imagePlus = WorkspaceItemUtil.getImgePlus(dataImage);
			width = imagePlus.getWidth();
			height = imagePlus.getHeight();

			thumbnailSize = WorkspaceItemUtil.getThumbnailDimension(width, height);
			thumbnailStream = WorkspaceItemUtil.getThumbnailAsPng(imagePlus,
					thumbnailSize);

		}catch (Exception e) {

			dataImage =  JCRImage.class.getResourceAsStream(noPreviewImg);

			imagePlus = WorkspaceItemUtil.getImgePlus(dataImage);
			width = imagePlus.getWidth();
			height = imagePlus.getHeight();
			thumbnailSize[0] = width;
			thumbnailSize[1] = height;
			thumbnailStream = JCRImage.class.getResourceAsStream(noPreviewImg);
			//			thumbnailSize = WorkspaceItemUtil.getThumbnailDimension(width, height);
			//			thumbnailStream = WorkspaceItemUtil.getThumbnailAsPng(imagePlus,
			//					thumbnailSize);
		}
		Binary binary = node.getSession().getValueFactory().createBinary(thumbnailStream);

		node.setProperty(IMAGE_WIDTH, width);
		node.setProperty(IMAGE_HEIGHT, height);
		node.setProperty(THUMBNAIL_WIDTH,  thumbnailSize[0]);
		node.setProperty(THUMBNAIL_HEIGHT, thumbnailSize[1]);
		node.setProperty(THUMBNAIL_DATA,binary);

		thumbnailStream.close();


		imagePlus.close();
		dataImage.close();
//		tmpFile.delete();
//		logger.trace("delete " + copydata.getAbsoluteFile() +" : " + copydata.delete());


	}

	@Override
	public int getWidth() {

		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return (int) node.getProperty(IMAGE_WIDTH).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	


	}

	@Override
	public int getHeight() {

		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return (int) node.getProperty(IMAGE_HEIGHT).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	
	}

	@Override
	public InputStream getThumbnail() throws InternalErrorException {
		Session session = JCRRepository.getSession();
		try {
			Node node = session.getNodeByIdentifier(nodeId);
			return node.getProperty(THUMBNAIL_DATA).getBinary().getStream();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}	
	}

	@Override
	public int getThumbnailWidth() {

		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return (int) node.getProperty(THUMBNAIL_WIDTH).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	

	}

	@Override
	public int getThumbnailHeight() {

		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return (int) node.getProperty(THUMBNAIL_HEIGHT).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	

	}

	@Override
	public long getThumbnailLength() throws InternalErrorException {

		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			return node.getProperty(THUMBNAIL_DATA).getBinary().getSize();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}	

	}


	@Override
	public String getPublicLink() throws InternalErrorException {
		return super.getPublicLink();
	}

	@Override
	public void updateInfo() throws InternalErrorException {
		//update size and mime type in JCRFile
		super.updateInfo();

		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(nodeId);
			setProperties(node);
			session.save();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			session.logout();
		}
	}

}
