/**
 * 
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryAdd;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryType;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;

/**
 * @author Valentina Marioli valentina.marioli@isti.cnr.it
 *
 */
public class JCRAccountingFolderEntryAdd extends JCRAccountingEntry implements
AccountingEntryAdd{

	/**
	 * @param user
	 * @param date
	 * @param itemName
	 */
	
	private static String ITEM_TYPE 			= "hl:itemType";
	private static String FOLDER_ITEM_TYPE 		= "hl:folderItemType";
	private static String ITEM_NAME 			= "hl:itemName";
	private static String MIME_TYPE 			= "hl:mimeType";
	
	protected WorkspaceItemType itemType;
	protected FolderItemType folderItemType;
	protected String itemName;
	protected String mimeType;
	
	
	public JCRAccountingFolderEntryAdd(Node node) throws RepositoryException {
		super(node);
		
		this.itemName =  node.getProperty(ITEM_NAME).getString();
		this.itemType =  WorkspaceItemType.valueOf(node.getProperty(ITEM_TYPE).getString());
		
		this.folderItemType = (node.hasProperty(FOLDER_ITEM_TYPE))? FolderItemType.valueOf(node.getProperty(FOLDER_ITEM_TYPE).getString()):null;
		this.mimeType = (node.hasProperty(MIME_TYPE)) ? node.getProperty(MIME_TYPE).getString() : null;
		
	}
	
	public JCRAccountingFolderEntryAdd(String user, Calendar date,
			WorkspaceItemType itemType, FolderItemType folderItemType,
			String itemName, String mimeType) {
		super(user, date);
		
		this.itemName = itemName;
		this.folderItemType = folderItemType;
		this.itemType = itemType;
		this.mimeType = mimeType;
	}

	@Override
	public AccountingEntryType getEntryType() {
		return AccountingEntryType.ADD;
	}

	@Override
	public WorkspaceItemType getItemType() {
		return itemType;
	}

	@Override
	public FolderItemType getFolderItemType() {
		return folderItemType;
	}

	@Override
	public String getItemName() {
		return itemName;
	}

	@Override
	public String mimeType() {
		return mimeType;
	}
	
	@Override
	public void save(Node entryNode) throws RepositoryException {
		super.save(entryNode);
		
		entryNode.setProperty(ITEM_NAME, itemName);
		entryNode.setProperty(ITEM_TYPE, itemType.toString());
		if (folderItemType != null)
			entryNode.setProperty(FOLDER_ITEM_TYPE, folderItemType.toString());
		if (mimeType != null)
			entryNode.setProperty(MIME_TYPE, mimeType);
	}
	
	@Override
	public String toString() {
		String parentValue = super.toString();
		return String.format("[%s [%s, itemName:%s, itemType:%s, folderItemType:%s, mimeType:%s]]",
				parentValue, AccountingEntryType.ADD, itemName, itemType, folderItemType, mimeType);
	}

}
