/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.search;

import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.search.SearchFolder;

public class JCRSearchFolder
implements SearchFolder {
    private static final String ROOT = "/";
    private static final String SHARED = "nthl:workspaceSharedItem";
    private final String id;
    private final Calendar creationDate;
    private final Calendar lastModified;
    private String owner;
    private final String type;
    private boolean isVreFolder;
    private boolean isShared;
    protected String name;

    public JCRSearchFolder(Node node, String name) throws RepositoryException {
        this.id = node.getIdentifier();
        this.name = name;
        this.creationDate = node.getProperty("jcr:created").getDate();
        this.lastModified = node.getProperty("jcr:lastModified").getDate();
        try {
            this.isVreFolder = node.getProperty("hl:isVreFolder").getBoolean();
            if (this.isVreFolder) {
                try {
                    this.name = node.getProperty("hl:displayName").getString();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            this.isVreFolder = false;
        }
        Node nodeOwner = null;
        try {
            nodeOwner = node.getNode("hl:owner");
            this.owner = nodeOwner.getProperty("hl:portalLogin").getString();
        }
        catch (Exception e) {
            this.owner = null;
        }
        try {
            this.isShared = this.isShared(node);
        }
        catch (InternalErrorException e) {
            // empty catch block
        }
        this.type = node.getPrimaryNodeType().getName();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isVreFolder() {
        return this.isVreFolder;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public WorkspaceItemType getType() {
        if (this.type.equals(SHARED)) {
            return WorkspaceItemType.SHARED_FOLDER;
        }
        return WorkspaceItemType.FOLDER;
    }

    private boolean isShared(Node node) throws InternalErrorException, AccessDeniedException, ItemNotFoundException, RepositoryException {
        return this.getIdSharedFolder(node) != null;
    }

    public String getIdSharedFolder(Node node) throws InternalErrorException, AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (node.getParent().getPath().equals(ROOT)) {
            return null;
        }
        if (node.getPrimaryNodeType().getName().equals(SHARED)) {
            return node.getIdentifier();
        }
        return this.getIdSharedFolder(node.getParent());
    }
}

