package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;

import org.apache.commons.lang.Validate;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.GCubeItem;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;

import com.thoughtworks.xstream.XStream;

public class JCRGCubeItem extends JCRWorkspaceItem implements GCubeItem {


	private static final String SCOPES 			= "hl:scopes";
	private static final String CREATOR 		= "hl:creator";
	private static final String ITEM_TYPE 		= "hl:itemType"; 
	private static final String PROPERTIES 		= "hl:properties";
	private static final String PROPERTY 		= "hl:property";
//TODO change jl
	private List<String> scopes;
	private String itemType;
	private String creator;
	private Map<String,String> properties = null;
	//	private JCRWorkspaceItem parent;

	protected String identifier;

	public JCRGCubeItem(JCRWorkspace workspace, Node node, String name,
			String description, List<String> scopes, String creator, String itemType, Map<String, String> properties) throws RepositoryException, ItemNotFoundException {
		super(workspace, node, name, description);

		Validate.notNull(scopes, "scopes must be not null");
		Validate.notNull(creator, "creator must be not null");
		Validate.notNull(itemType, "item type must be not null");

		this.identifier = node.getIdentifier();

		//		this.parent = (JCRWorkspaceItem) workspace.getItem(node.getParent().getIdentifier());
		this.scopes =  scopes;
		this.creator = creator;
		this.itemType = itemType;
		this.properties = properties;		

		node.setProperty(CREATOR, creator);
		node.setProperty(ITEM_TYPE, itemType);
		node.setProperty(SCOPES, scopes.toArray(new String[0]));


		if (properties!=null){
			//			node.setProperty(PROPERTIES, new XStream().toXML(properties));
			setProperties(node, properties);
		}
	}

	@SuppressWarnings("unchecked")
	public JCRGCubeItem(JCRWorkspace workspace, Node node)
			throws RepositoryException {
		super(workspace, node);
		this.identifier = node.getIdentifier();
		this.scopes =new ArrayList<String>();
		for (Value value : node.getProperty(SCOPES).getValues())
			scopes.add(value.getString());
		creator = node.getProperty(CREATOR).getString();
		itemType = node.getProperty(ITEM_TYPE).getString();
		if (node.hasProperty(PROPERTIES) && node.getProperty(PROPERTIES)!=null) 
			properties =(Map<String, String>) new XStream().fromXML(node.getProperty(PROPERTIES).getString());
		else properties = Collections.emptyMap();
	}

	@Override
	public void setItemProperties(Map<String, String> properties) throws InternalErrorException {
		
		this.properties = properties;	
		
		Session session = null;
		Node node = null;
		try {
			session = JCRRepository.getSession();
			node = session.getNodeByIdentifier(identifier);
			if (properties!=null){
				setProperties(node, properties);
				//				node.setProperty(PROPERTIES, new XStream().toXML(properties));
			}
			session.save();
		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}			

	}


	private void setProperties(Node node, Map<String, String> properties) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
		Node propertiesNode;
		try{
			propertiesNode = node.getNode(PROPERTY);
		}catch (Exception e) {
			propertiesNode = node.addNode(PROPERTY);
		}

		for (Map.Entry<String, String> entry : properties.entrySet()) {
			propertiesNode.setProperty(entry.getKey(), entry.getValue());

		}
	}


	@Override
	public WorkspaceItemType getType() {
		return WorkspaceItemType.FOLDER_ITEM;
	}

	@Override
	public List<? extends WorkspaceItem> getChildren()
			throws InternalErrorException {
		return null;
	}

	@Override
	public List<String> getScopes() throws InternalErrorException {

		return scopes;
	}

	@Override
	public String getItemType() {
		return itemType;
	}

	@Override
	public String getCreator() {
		return creator;
	}

	@Override
	public Map<String, String> getItemProperties() throws InternalErrorException {

		Map<String, String> propertiesList = new HashMap<String, String>();
		Session session = null;
		Node node = null;
		try {
			session = JCRRepository.getSession();
			node = session.getNodeByIdentifier(identifier);
		//test	
			PropertyIterator prope = node.getNode(PROPERTY).getProperties();
			while (prope.hasNext()){
				Property property = prope.nextProperty();
				String key = property.getName();
				String value = property.getString();
			}
			
		//end test	
			
			
			PropertyIterator prop;
			try{
				prop = node.getNode(PROPERTY).getProperties();
			}catch (Exception e) {
				return properties;
			}

			while (prop.hasNext()){
				Property property = prop.nextProperty();
				String key = property.getName();
				String value = property.getString();
				propertiesList.put(key, value);
			}
			session.save();

		} catch (RepositoryException e) {
			throw new InternalErrorException(e);
		} catch (InternalErrorException e) {
			throw new InternalErrorException(e);
		} finally {
			session.logout();
		}
		return propertiesList;	

		//		return properties;
	}


	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.GCUBE_ITEM;
	}

	@Override
	public long getLength() throws InternalErrorException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public String getMimeType() throws InternalErrorException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem#move(org.gcube.common.homelibrary.home.workspace.WorkspaceFolder)
	 */
	@Override
	public void move(WorkspaceFolder destination)
			throws InternalErrorException, WrongDestinationException,
			InsufficientPrivilegesException, ItemAlreadyExistException {
		throw new InsufficientPrivilegesException("GCUBEItem cannot be moved");
	}

	/* (non-Javadoc)
	 * @see org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem#internalCopy(javax.jcr.Node, java.lang.String)
	 */
	@Override
	public Node internalCopy(Node nodeFolder, String newName)
			throws InternalErrorException, ItemAlreadyExistException,
			WrongDestinationException, RepositoryException {
		throw new InternalErrorException("GCUBEItem cannot be copied");
	}

	/* (non-Javadoc)
	 * @see org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem#internalMove(javax.jcr.Node)
	 */
	@Override
	public void internalMove(Node destinationFolderNode)
			throws ItemAlreadyExistException, InternalErrorException,
			RepositoryException {
		throw new InternalErrorException("GCUBEItem cannot be moved");
	}

	@Override
	public String getWorkflowId() throws InternalErrorException {
		return null;
	}

	@Override
	public void setWorkflowId(String id) throws InternalErrorException {
	}

	@Override
	public String getWorkflowStatus() throws InternalErrorException {
		return null;
	}

	@Override
	public void setWorkflowStatus(String status) throws InternalErrorException {
	}

	@Override
	public String getWorkflowData() throws InternalErrorException {
		return null;
	}

	@Override
	public void setWorkflowData(String data) throws InternalErrorException {

	}

	@Override
	public void removeChild(WorkspaceItem child) throws InternalErrorException,
	InsufficientPrivilegesException {

	}





}
