/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRead;
import org.gcube.common.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongItemTypeException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.resolver.UriResolverReaderParameter;
import org.gcube.common.homelibrary.jcr.shortner.UrlShortener;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRProperties;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryAddACL;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryCreate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryDeleteACL;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryModifyACL;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRead;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryShare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryType;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUnshare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.util.HttpRequestUtil;
import org.gcube.common.homelibrary.jcr.workspace.util.StringUtil;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JCRWorkspaceItem
implements WorkspaceItem {
    public static final String TITLE = "jcr:title";
    public static final String CREATED = "jcr:created";
    public static final String LAST_MODIFIED = "jcr:lastModified";
    public static final String OWNER = "hl:owner";
    public static final String PORTAL_LOGIN = "hl:portalLogin";
    public static final String ISVREFOLDER = "hl:isVreFolder";
    public static final String DISPLAY_NAME = "hl:displayName";
    protected static final String LAST_MODIFIED_BY = "jcr:lastModifiedBy";
    protected static final String DESCRIPTION = "jcr:description";
    protected static final String LAST_ACTION = "hl:lastAction";
    protected static final String READERS = "hl:readers";
    protected static final String NT_READERS = "nthl:readersSet";
    protected static final String ACCOUNTING = "hl:accounting";
    protected static final String NT_ACCOUNTING = "nthl:accountingSet";
    public static final String USERS = "hl:users";
    private static final String USER_ID = "hl:uuid";
    private static final String NT_USER = "nthl:user";
    public static final String NT_WORKSPACE_FILE = "nthl:externalFile";
    public static final String NT_WORKSPACE_IMAGE = "nthl:externalImage";
    public static final String NT_WORKSPACE_PDF_FILE = "nthl:externalPdf";
    private static final String CONTENT = "jcr:content";
    private static final String READ = "nthl:accountingEntryRead";
    protected final JCRWorkspace workspace;
    protected String identifier;
    protected String userId;
    protected String portalLogin;
    protected Calendar creationDate;
    protected JCRProperties properties;
    protected static Logger logger = LoggerFactory.getLogger(JCRWorkspaceItem.class);

    public JCRWorkspaceItem(JCRWorkspace workspace, Node node) throws RepositoryException {
        this.workspace = workspace;
        this.identifier = node.getIdentifier();
        this.creationDate = node.getProperty(CREATED).getDate();
        try {
            this.portalLogin = node.getProperty(PORTAL_LOGIN).getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.portalLogin == null) {
            try {
                Node nodeOwner = node.getNode(OWNER);
                this.userId = nodeOwner.getProperty(USER_ID).getString();
                this.portalLogin = nodeOwner.getProperty(PORTAL_LOGIN).getString();
                node.getSession().save();
            }
            catch (PathNotFoundException e) {
                try {
                    Node nodeOwner = node.addNode(OWNER, NT_USER);
                    this.setOwnerNode(nodeOwner);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }
    }

    public JCRWorkspaceItem(JCRWorkspace workspace, Node node, String name, String description) throws RepositoryException {
        Validate.notNull((Object)name, (String)"Name must be not null");
        Validate.notNull((Object)description, (String)"Description must be not null");
        this.workspace = workspace;
        this.identifier = node.getIdentifier();
        this.creationDate = node.getProperty(CREATED).getDate();
        node.setProperty(LAST_MODIFIED_BY, workspace.getOwner().getPortalLogin());
        node.setProperty(DESCRIPTION, description);
        node.setProperty(TITLE, name);
        node.setProperty(LAST_ACTION, WorkspaceItemAction.CREATED.toString());
        node.setProperty(PORTAL_LOGIN, workspace.getOwner().getPortalLogin());
    }

    public void setOwnerNode(Node nodeOwner) throws RepositoryException {
        nodeOwner.setProperty(PORTAL_LOGIN, this.workspace.getOwner().getPortalLogin());
        nodeOwner.setProperty(USER_ID, UUID.randomUUID().toString());
    }

    public User getOwner() {
        return new JCRUser(this.userId, this.portalLogin);
    }

    public void save(Node node) throws RepositoryException {
        node.getSession().save();
        this.identifier = node.getIdentifier();
        this.creationDate = node.getProperty(CREATED).getDate();
    }

    public String getId() throws InternalErrorException {
        return this.identifier;
    }

    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String name;
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = name = node.getProperty(TITLE).getString();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getDescription() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            String string = node.getProperty(DESCRIPTION).getString();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void setDescription(String description) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            try {
                this.internalDescription(session.getNodeByIdentifier(this.identifier), description);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public void rename(String name) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            this.workspace.renameItem(this.getId(), name);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Calendar getCreationTime() throws InternalErrorException {
        return this.creationDate;
    }

    public Calendar getLastModificationTime() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Calendar calendar = node.getProperty(LAST_MODIFIED).getDate();
            return calendar;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceItemAction getLastAction() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            WorkspaceItemAction workspaceItemAction = WorkspaceItemAction.valueOf((String)node.getProperty(LAST_ACTION).getString());
            return workspaceItemAction;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public Properties getProperties() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            JCRProperties jCRProperties = new JCRProperties(node);
            return jCRProperties;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void addAccountingEntry(AccountingEntry entry) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            if (!node.hasNode(ACCOUNTING)) {
                node.addNode(ACCOUNTING, NT_ACCOUNTING);
                session.save();
            }
            Node accountingNode = node.getNode(ACCOUNTING);
            JCRAccountingEntryType nodeType = JCRAccountingEntryType.valueOf(entry.getEntryType().toString());
            logger.debug("Accountin node type " + nodeType.getNodeTypeDefinition());
            Node entryNode = accountingNode.addNode(UUID.randomUUID().toString(), nodeType.getNodeTypeDefinition());
            ((JCRAccountingEntry)entry).save(entryNode);
            session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<AccountingEntry> getAccounting() {
        ArrayList<AccountingEntry> list = new ArrayList<AccountingEntry>();
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node node = session.getNodeByIdentifier(this.identifier);
            JCRAccountingEntryCreate entry = new JCRAccountingEntryCreate(this.getOwner().getPortalLogin(), this.getCreationTime(), node.getName());
            list.add(entry);
            Node accountingNode = node.getNode(ACCOUNTING);
            NodeIterator iterator = accountingNode.getNodes();
            while (iterator.hasNext()) {
                Node entryNode = (Node)iterator.next();
                try {
                    switch (JCRAccountingEntryType.getEnum(entryNode.getPrimaryNodeType().getName())) {
                        case CUT: {
                            list.add(new JCRAccountingFolderEntryCut(entryNode));
                            break;
                        }
                        case PASTE: {
                            list.add(new JCRAccountingEntryPaste(entryNode));
                            break;
                        }
                        case REMOVAL: {
                            list.add(new JCRAccountingFolderEntryRemoval(entryNode));
                            break;
                        }
                        case RENAMING: {
                            list.add(new JCRAccountingEntryRenaming(entryNode));
                            break;
                        }
                        case ADD: {
                            list.add(new JCRAccountingFolderEntryAdd(entryNode));
                            break;
                        }
                        case UPDATE: {
                            list.add(new JCRAccountingEntryUpdate(entryNode));
                            break;
                        }
                        case READ: {
                            list.add(new JCRAccountingEntryRead(entryNode));
                            break;
                        }
                        case SHARE: {
                            list.add(new JCRAccountingEntryShare(entryNode));
                            break;
                        }
                        case UNSHARE: {
                            list.add(new JCRAccountingEntryUnshare(entryNode));
                            break;
                        }
                        case ADD_ACL: {
                            list.add(new JCRAccountingEntryAddACL(entryNode));
                            break;
                        }
                        case MODIFY_ACL: {
                            list.add(new JCRAccountingEntryModifyACL(entryNode));
                            break;
                        }
                        case DELETE_ACL: {
                            list.add(new JCRAccountingEntryDeleteACL(entryNode));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Accounting entry skipped " + entryNode.getPrimaryNodeType().getName(), (Throwable)e);
                }
            }
            try {
                List<AccountingEntryRead> readersList = this.getReadersNode();
                for (AccountingEntryRead reader : readersList) {
                    list.add((AccountingEntry)reader);
                }
            }
            catch (Exception e) {
                logger.debug("Node Readers does not exist in " + node.getPath());
            }
            ArrayList<AccountingEntry> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("Error to retrieve accounting entries ", (Throwable)e);
            ArrayList<AccountingEntry> arrayList = list;
            return arrayList;
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    public List<AccountingEntryRead> getReadersNode() throws InternalErrorException {
        ArrayList<AccountingEntryRead> list = new ArrayList<AccountingEntryRead>();
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Node readersNode = node.getNode(READERS);
            NodeIterator iterator = readersNode.getNodes();
            while (iterator.hasNext()) {
                Node reader = iterator.nextNode();
                if (JCRAccountingEntryType.getEnum(reader.getPrimaryNodeType().getName()) == null) continue;
                list.add(new JCRAccountingEntryRead(reader));
            }
            ArrayList<AccountingEntryRead> arrayList = list;
            return arrayList;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public WorkspaceFolder getParent() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            JCRAbstractWorkspaceFolder jCRAbstractWorkspaceFolder = this.workspace.getParent(session.getNodeByIdentifier(this.identifier));
            return jCRAbstractWorkspaceFolder;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    protected JCRAbstractWorkspaceFolder getParent(Node node) throws InternalErrorException {
        try {
            return this.workspace.getParent(node);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isShared() throws InternalErrorException {
        return this.getIdSharedFolder() != null;
    }

    public String getIdSharedFolder() throws InternalErrorException {
        if (this.isRoot()) {
            return null;
        }
        if (this.getType() == WorkspaceItemType.SHARED_FOLDER) {
            return this.getId();
        }
        return ((JCRWorkspaceItem)this.getParent()).getIdSharedFolder();
    }

    public String getPath() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            String string = this.getPath(session.getNodeByIdentifier(this.identifier));
            return string;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getPath(Node node) throws RepositoryException, InternalErrorException {
        System.out.println("node " + node.getPath() + " " + node.getPrimaryNodeType().getName());
        if (node.getPath().contains("/Home/" + this.getOwner().getPortalLogin() + "/Workspace/Trash/")) {
            return "/Trash/" + node.getName();
        }
        if (this.isRoot(node)) {
            return String.valueOf(this.workspace.getPathSeparator()) + node.getProperty(TITLE).getString();
        }
        return String.valueOf(this.getParent(node).getPath(node.getParent())) + this.workspace.getPathSeparator() + node.getProperty(TITLE).getString();
    }

    public boolean isRoot() throws InternalErrorException {
        return this.getParent() == null;
    }

    public boolean isRoot(Node node) throws RepositoryException, InternalErrorException {
        return this.workspace.getParent(node) == null;
    }

    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        try {
            this.workspace.removeItem(this.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void move(WorkspaceFolder destination) throws InternalErrorException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            this.workspace.moveItem(this.getId(), destination.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem cloneItem(String cloneName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            return this.workspace.cloneItem(this.getId(), cloneName);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public Node internalCopy(Node nodeFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        Node node = nodeFolder.getSession().getNodeByIdentifier(this.identifier);
        String pathNewNode = null;
        try {
            pathNewNode = String.valueOf(nodeFolder.getPath()) + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
            if (node.getSession().getNode(pathNewNode) != null) {
                WorkspaceFolder destinationFolder = (WorkspaceFolder)this.workspace.getItem(nodeFolder.getSession(), nodeFolder.getIdentifier());
                newName = WorkspaceUtil.getCopyName((String)Text.escapeIllegalJcrChars((String)newName), (WorkspaceFolder)destinationFolder);
                pathNewNode = String.valueOf(nodeFolder.getPath()) + this.workspace.getPathSeparator() + newName;
            }
        }
        catch (RepositoryException | ItemNotFoundException destinationFolder) {
            // empty catch block
        }
        try {
            logger.trace("copy: " + node.getPath() + " - to: " + pathNewNode);
            node.getSession().getWorkspace().copy(node.getPath(), pathNewNode);
            node.getSession().save();
            Node newNode = node.getSession().getNode(pathNewNode);
            newNode.setProperty(LAST_MODIFIED, Calendar.getInstance());
            newNode.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            newNode.setProperty(TITLE, Text.escapeIllegalJcrChars((String)newName));
            newNode.setProperty(LAST_ACTION, WorkspaceItemAction.CLONED.toString());
            newNode.getSession().save();
            return newNode;
        }
        catch (ItemExistsException e) {
            throw new ItemAlreadyExistException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalMove(Node destinationFolderNode) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getIdentifier());
            Node node = destinationFolderNode.getSession().getNodeByIdentifier(this.identifier);
            if (this.workspace.exists(node.getName(), destinationFolderNode.getIdentifier())) {
                logger.error("Item with name " + this.getName() + " exists");
                throw new ItemAlreadyExistException("Item " + node.getName() + " already exists");
            }
            node.setProperty(LAST_MODIFIED, Calendar.getInstance());
            node.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            node.setProperty(LAST_ACTION, WorkspaceItemAction.MOVED.toString());
            node.getSession().save();
            node.getSession().getWorkspace().move(node.getPath(), String.valueOf(destinationFolderNode.getPath()) + this.workspace.getPathSeparator() + node.getName());
        }
        catch (RepositoryException e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalRename(Node node, String newName) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            logger.debug("Internal rename item with id " + this.getId() + " to destination item with id " + node.getParent().getIdentifier());
            if (this.workspace.exists(nodeNewName, node.getParent().getIdentifier())) {
                logger.error("Item with name " + nodeNewName + " exists");
                throw new ItemAlreadyExistException("Item " + nodeNewName + " already exists");
            }
            String newPath = String.valueOf(node.getParent().getPath()) + this.workspace.getPathSeparator() + nodeNewName;
            node.setProperty(LAST_MODIFIED, Calendar.getInstance());
            node.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            node.setProperty(LAST_ACTION, WorkspaceItemAction.RENAMED.toString());
            node.setProperty(TITLE, newName);
            node.getSession().save();
            String path = node.getPath();
            node.getSession().getWorkspace().move(path, newPath);
        }
        catch (RepositoryException e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongItemTypeException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
        catch (ItemNotFoundException e) {
            logger.error("Unhandled Exception ");
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalDescription(Node node, String newDescription) throws InternalErrorException {
        Validate.notNull((Object)newDescription, (String)"Description must be not null");
        try {
            node.setProperty(DESCRIPTION, newDescription);
            node.setProperty(LAST_MODIFIED, Calendar.getInstance());
            node.setProperty(LAST_MODIFIED_BY, this.workspace.getOwner().getPortalLogin());
            node.getSession().save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isMarkedAsRead() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            boolean bl = this.hasReaders(session);
            return bl;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    private boolean hasReaders(Session session) throws RepositoryException, InternalErrorException {
        Node node = session.getNodeByIdentifier(this.getId());
        int count = 0;
        try {
            Node accountingNode = node.getNode(ACCOUNTING);
            NodeIterator iteratorEntry = accountingNode.getNodes();
            while (iteratorEntry.hasNext()) {
                Node readersNode = (Node)iteratorEntry.next();
                try {
                    String entry = readersNode.getPrimaryNodeType().getName();
                    if (!entry.equals(READ)) continue;
                    ++count;
                }
                catch (Exception e) {
                    logger.info("Node ACCOUNTING not found");
                }
            }
            return count > 0;
        }
        catch (PathNotFoundException e) {
            logger.info("Node READERS has been added to " + node.getPath());
            return false;
        }
    }

    public List<AccountingEntryRead> getReaders() throws InternalErrorException {
        ArrayList<AccountingEntryRead> list = new ArrayList<AccountingEntryRead>();
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.identifier);
            Node accountingNode = node.getNode(ACCOUNTING);
            NodeIterator iteratorEntry = accountingNode.getNodes();
            while (iteratorEntry.hasNext()) {
                Node readersNode = (Node)iteratorEntry.next();
                try {
                    String entry = readersNode.getPrimaryNodeType().getName();
                    if (!entry.equals(READ)) continue;
                    list.add(new JCRAccountingEntryRead(readersNode));
                }
                catch (Exception e) {
                    logger.info("Node ACCOUNTING not found");
                }
            }
            ArrayList<AccountingEntryRead> arrayList = list;
            return arrayList;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void setShareHistory(List<String> users, String author) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            try {
                this.setShare(users, author);
                this.setHistoryShareUnshare(this, JCRAccountingEntryType.SHARE.getNodeTypeDefinition(), author, users);
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    private void setHistoryShareUnshare(WorkspaceItem item, String operation, String user, List<String> members) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        for (WorkspaceItem child : item.getChildren()) {
            try {
                if (child.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM) || child.getType().equals((Object)WorkspaceItemType.FOLDER)) {
                    if (operation.equals(JCRAccountingEntryType.UNSHARE.getNodeTypeDefinition())) {
                        ((JCRWorkspaceItem)child).setUnshare(user);
                    } else if (operation.equals(JCRAccountingEntryType.SHARE.getNodeTypeDefinition())) {
                        ((JCRWorkspaceItem)child).setShare(members, user);
                    }
                }
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            if (child.getChildren().size() <= 0) continue;
            this.setHistoryShareUnshare(child, operation, user, members);
        }
    }

    public void setUnshareHistory(String user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            try {
                this.setUnshare(user);
                try {
                    this.setHistoryShareUnshare(this, JCRAccountingEntryType.UNSHARE.getNodeTypeDefinition(), user, null);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public void setShare(List<String> users, String author) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.getId());
                if (!node.hasNode(ACCOUNTING)) {
                    node.addNode(ACCOUNTING, NT_ACCOUNTING);
                    session.save();
                }
                logger.info("Add SHARE operation for user " + author + " to node " + node.getPath());
                Node accounting = node.getNode(ACCOUNTING);
                JCRAccountingEntryShare entry = new JCRAccountingEntryShare(author, Calendar.getInstance(), this.getName(), users);
                entry.save(accounting.addNode(UUID.randomUUID().toString(), JCRAccountingEntryType.SHARE.getNodeTypeDefinition()));
                session.save();
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public void setUnshare(String user) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.getId());
                if (!node.hasNode(ACCOUNTING)) {
                    node.addNode(ACCOUNTING, NT_ACCOUNTING);
                    session.save();
                }
                logger.info("Add UNSHARE operation for user " + user);
                Node accounting = node.getNode(ACCOUNTING);
                JCRAccountingEntryUnshare entry = new JCRAccountingEntryUnshare(user, Calendar.getInstance(), this.getName());
                entry.save(accounting.addNode(UUID.randomUUID().toString(), JCRAccountingEntryType.UNSHARE.getNodeTypeDefinition()));
                session.save();
            }
            catch (Exception e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public void markAsRead(boolean read) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.getId());
                if (!node.hasNode(ACCOUNTING)) {
                    node.addNode(ACCOUNTING, NT_ACCOUNTING);
                    session.save();
                }
                logger.info("Mark Node " + node.getPath() + " As Read ");
                Node parentNode = node.getParent();
                String parentPath = parentNode.getPath();
                String user = this.workspace.getOwner().getPortalLogin();
                Node accounting = node.getNode(ACCOUNTING);
                WorkspaceItem item = this.workspace.getItem(session, node.getIdentifier());
                String name = item.getName();
                if (read) {
                    logger.info("Setting " + node.getName() + " as read in " + node.getPath());
                    JCRAccountingEntryRead entry = new JCRAccountingEntryRead(user, Calendar.getInstance(), name);
                    entry.save(accounting.addNode(UUID.randomUUID().toString(), JCRAccountingEntryType.READ.getNodeTypeDefinition()));
                    session.save();
                    try {
                        logger.info("Mark Parent Node " + parentNode.getPath() + " As Read ");
                        Node accountingParentNode = parentNode.getNode(ACCOUNTING);
                        JCRAccountingEntryRead entryParent = new JCRAccountingEntryRead(user, Calendar.getInstance(), name);
                        entryParent.save(accountingParentNode.addNode(UUID.randomUUID().toString(), JCRAccountingEntryType.READ.getNodeTypeDefinition()));
                        session.save();
                        logger.info("Set " + name + " as read in " + parentPath);
                    }
                    catch (Exception e) {
                        logger.info("Error setting " + name + " as read in " + parentPath);
                    }
                }
                session.save();
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
    }

    public String getRemotePath() throws InternalErrorException {
        Node nodeItem;
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            nodeItem = session.getNodeByIdentifier(this.identifier);
        }
        catch (javax.jcr.ItemNotFoundException e2) {
            throw new InternalErrorException((Throwable)e2);
        }
        catch (RepositoryException e2) {
            throw new InternalErrorException((Throwable)e2);
        }
        try {
            try {
                Node contentNode = nodeItem.getNode(CONTENT);
                if (contentNode.hasProperty("hl:remotePath")) {
                    remotePath = contentNode.getProperty("hl:remotePath").getString();
                }
            }
            catch (RepositoryException e) {
                try {
                    if (nodeItem.hasProperty("hl:remotePath")) {
                        remotePath = nodeItem.getProperty("hl:remotePath").getString();
                    }
                }
                catch (Exception e1) {
                    throw new InternalErrorException((Throwable)e1);
                }
                session.logout();
            }
        }
        finally {
            session.logout();
        }
        return remotePath;
    }

    public void setRemotePath(String remotePath, Node node) throws InternalErrorException, RepositoryException {
        Session session = node != null ? node.getSession() : JCRRepository.getSession();
        try {
            try {
                Node nodeItem = session.getNodeByIdentifier(this.identifier);
                try {
                    Node contentNode = nodeItem.getNode(CONTENT);
                    if (contentNode.hasProperty("hl:remotePath")) {
                        contentNode.setProperty("hl:remotePath", remotePath);
                    }
                    session.save();
                }
                catch (Exception e) {
                    try {
                        nodeItem.setProperty("hl:remotePath", remotePath);
                        session.save();
                    }
                    catch (Exception e1) {
                        throw new InternalErrorException((Throwable)e1);
                    }
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            if (node == null) {
                session.logout();
            }
        }
    }

    public void setNewRemotePath(String remotePath, Node node) throws InternalErrorException, RepositoryException {
        Session session = node != null ? node.getSession() : JCRRepository.getSession();
        try {
            try {
                Node nodeItem = session.getNodeByIdentifier(this.identifier);
                nodeItem.setProperty("hl:storagePath", remotePath);
                session.save();
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            if (node == null) {
                session.logout();
            }
        }
    }

    public LockManager getLock(Node node) throws InternalErrorException {
        LockManager lockManager = null;
        try {
            lockManager = node.getSession().getWorkspace().getLockManager();
            Lock lock = null;
            try {
                lock = lockManager.getLock(node.getPath());
            }
            catch (LockException lockException) {
                // empty catch block
            }
            if (lock != null) {
                lockManager.addLockToken(lock.getLockToken());
                lockManager.unlock(node.getPath());
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new InternalErrorException((Throwable)e);
        }
        return lockManager;
    }

    public void setOwnerToCurrentUser(WorkspaceItem item) throws RepositoryException, InternalErrorException {
        try {
            Session session = JCRRepository.getSession();
            if (item.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM) || item.getType().equals((Object)WorkspaceItemType.FOLDER)) {
                Node itemUnshared = session.getNodeByIdentifier(item.getId());
                Node nodeOwner = null;
                try {
                    nodeOwner = itemUnshared.getNode(OWNER);
                }
                catch (Exception e) {
                    nodeOwner = itemUnshared.addNode(OWNER, NT_USER);
                    session.save();
                }
                this.setOwnerNode(nodeOwner);
                session.save();
            }
            List children = null;
            try {
                children = item.getChildren();
            }
            catch (Exception nodeOwner) {
                // empty catch block
            }
            if (children != null) {
                for (WorkspaceItem child : children) {
                    this.setOwnerToCurrentUser(child);
                }
            }
        }
        catch (InternalErrorException e1) {
            throw new InternalErrorException((Throwable)e1);
        }
    }

    public List<String> getUsers() throws InternalErrorException {
        ArrayList<String> list = new ArrayList<String>();
        Session session = JCRRepository.getSession();
        try {
            try {
                Node node = session.getNodeByIdentifier(this.getId());
                Node usersNode = node.getNode(USERS);
                PropertyIterator iterator = usersNode.getProperties();
                while (iterator.hasNext()) {
                    Property property = iterator.nextProperty();
                    String name = property.getName();
                    if (name.startsWith("jcr:") || name.startsWith("hl:")) continue;
                    list.add(name);
                }
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            session.logout();
        }
        return list;
    }

    public boolean isFolder() throws InternalErrorException {
        return this.getType().equals((Object)WorkspaceItemType.FOLDER) || this.getType().equals((Object)WorkspaceItemType.SHARED_FOLDER);
    }

    public String getPublicLink(boolean shortenUrl) throws InternalErrorException {
        logger.info("get PublicLink for item: " + this.getName());
        String publicLink = null;
        if (this.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) {
            FolderItem folderItem = (FolderItem)this;
            try {
                String smpUri = this.getPubliLinkForFolderItem(folderItem);
                publicLink = this.getPublicLinkForFolderItemId(smpUri, folderItem, shortenUrl);
            }
            catch (Exception e) {
                throw new InternalErrorException("Sorry, Public Link for selected file is unavailable");
            }
        } else {
            logger.warn("ItemId: " + this.getId() + " is not a folder item, sent exception Public Link  unavailable");
            throw new InternalErrorException("Sorry, Public Link for selected file is unavailable");
        }
        return publicLink;
    }

    private String getPubliLinkForFolderItem(FolderItem folderItem) throws InternalErrorException {
        return GCUBEStorage.getPublicLink(folderItem.getRemotePath(), this.portalLogin);
    }

    public String getPublicLinkForFolderItemId(String smpUri, FolderItem folderItem, boolean shortenUrl) throws InternalErrorException {
        logger.trace("get Public Link ");
        try {
            if (smpUri == null || smpUri.isEmpty()) {
                throw new Exception("Sorry, public link on " + folderItem.getName() + " is not available");
            }
            UriResolverReaderParameter uriResolver = new UriResolverReaderParameter(ScopeProvider.instance.get());
            String uriRequest = "";
            if (uriResolver != null && uriResolver.isAvailable()) {
                String itemName = StringUtil.removeSpecialCharacters(folderItem.getName());
                uriRequest = uriResolver.resolveAsUriRequest(smpUri, itemName = StringUtil.replaceAllWhiteSpace(itemName, "_"), folderItem.getMimeType(), true);
                if (!HttpRequestUtil.urlExists(uriRequest)) {
                    throw new InternalErrorException("Sorry, The Public Link for selected file is unavailable");
                }
                if (shortenUrl) {
                    uriRequest = this.getShortUrl(uriRequest);
                }
                return uriRequest;
            }
            throw new InternalErrorException("Sorry, The Uri resolver service is temporarily unavailable. Please try again later");
        }
        catch (Exception e) {
            logger.error("Error getPublicLinkForFolderItemId for item: " + folderItem.getId(), (Throwable)e);
            throw new InternalErrorException(e.getMessage());
        }
    }

    public String getShortUrl(String longUrl) throws Exception {
        logger.trace("get short url for " + longUrl);
        UrlShortener shortener = new UrlShortener(ScopeProvider.instance.get());
        try {
            if (shortener != null && shortener.isAvailable()) {
                return shortener.shorten(longUrl);
            }
            return longUrl;
        }
        catch (Exception e) {
            logger.error("Error get short url for ", (Throwable)e);
            return longUrl;
        }
    }

    public boolean isTrashed() throws InternalErrorException {
        return this.getPath().startsWith("/Trash/");
    }
}

