/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.repository.external;

import java.io.IOException;
import java.io.InputStream;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCUBEStorage {
    private static Logger logger = LoggerFactory.getLogger(GCUBEStorage.class);

    public static IClient getStorage(String portalLogin) {
        IClient storage = null;
        logger.trace("Calling GCUBEStorage from user: " + portalLogin);
        try {
            String currentScope = ScopeProvider.instance.get();
            String scope = Utils.getRootScope(currentScope);
            ScopeProvider.instance.set(scope);
            logger.trace("GCUBE Storage scope : " + scope);
            storage = new StorageClient("org.gcube.portlets.user", JCRRepository.serviceName, portalLogin, AccessType.SHARED, currentScope, false).getClient();
            Handler.activateProtocol();
        }
        catch (Exception e) {
            logger.error("GCUBE Storage initialization failed", (Throwable)e);
        }
        return storage;
    }

    public static String putStream(InputStream is, String remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage - putStream - remotePath: " + remotePath);
        IClient storage = GCUBEStorage.getStorage(portalLogin);
        storage.put(true).LFile(is).RFile(remotePath);
        try {
            is.close();
            logger.trace("GCUBE Storage inputStream closed");
        }
        catch (IOException e) {
            logger.error("GCUBE Storage error during to close inputStream", (Throwable)e);
        }
        return GCUBEStorage.getStorage(portalLogin).getUrl().RFile(remotePath);
    }

    public static String putStream(String old_remotePath, String new_remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage -putStream - remotePath: " + new_remotePath);
        IClient storage = GCUBEStorage.getStorage(portalLogin);
        storage.put(true).LFile(old_remotePath).RFile(new_remotePath);
        return GCUBEStorage.getStorage(portalLogin).getUrl().RFile(new_remotePath);
    }

    public static long getRemoteFileSize(String remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage getRemoteFileSize - storage.getSize().RFile(" + remotePath + ")");
        IClient storage = GCUBEStorage.getStorage(portalLogin);
        long size = storage.getSize().RFile(remotePath);
        return size;
    }

    public static void removeRemoteFile(String remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage - removeRemoteFile - remotePath: " + remotePath);
        GCUBEStorage.getStorage(portalLogin).remove().RFile(remotePath);
    }

    public static void removeRemoteFolder(String remotePath, String portalLogin) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.removeDir().RDir(" + remotePath + ")");
        IClient storage = GCUBEStorage.getStorage(portalLogin);
        storage.removeDir().RDir(remotePath);
    }

    public static InputStream getRemoteFile(String remotePath, String portalLogin) {
        logger.trace("GCUBE Storage -getRemoteFile - stream = storage.get().RFileAsInputStream(" + remotePath + ")");
        InputStream stream = null;
        IClient storage = GCUBEStorage.getStorage(portalLogin);
        try {
            stream = storage.get().RFileAsInputStream(remotePath);
        }
        catch (Exception e) {
            logger.error("no payload found in Storage for remotePath: " + remotePath);
        }
        return stream;
    }

    public static String getPublicLink(String remotePath, String portalLogin) {
        logger.trace("GCUBE Storage - Generate Public Link for " + remotePath);
        IClient storage = GCUBEStorage.getStorage(portalLogin);
        String publicUrl = storage.getUrl().RFile(remotePath);
        return publicUrl;
    }

    public static void moveRemoteFolder(String oldPath, String newPath, String portalLogin) {
        logger.trace("GCUBE Storage - storage.moveDir().from(" + oldPath + ").to(" + newPath + ")");
        IClient storage = GCUBEStorage.getStorage(portalLogin);
        storage.moveDir().from(oldPath).to(newPath);
    }

    public static void moveRemoteFile(String oldPath, String newPath, String portalLogin) {
        logger.trace("GCUBE Storage - storage.moveFile().from(" + oldPath + ").to(" + newPath + ")");
        IClient storage = GCUBEStorage.getStorage(portalLogin);
        storage.moveFile().from(oldPath).to(newPath);
    }

    public static void copyRemoteFile(String oldPath, String newPath, String portalLogin) {
        logger.trace("GCUBE Storage - storage.copyFile().from(" + oldPath + ").to(" + newPath + ")");
        IClient storage = GCUBEStorage.getStorage(portalLogin);
        storage.copyFile().from(oldPath).to(newPath);
    }

    public static void createHardLink(String srcPath, String destPath, String portalLogin) {
        try {
            logger.trace("GCUBE Storage - storage.linkFile().from(" + srcPath + ").to(" + destPath + ")");
            IClient storage = GCUBEStorage.getStorage(portalLogin);
            storage.linkFile().from(srcPath).to(destPath);
        }
        catch (Exception e) {
            logger.error("GCUBE Storage error creating a linkFile", (Throwable)e);
        }
    }

    public static void removeRemoteFolder(String remotePath, String portalLogin, String serviceName) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.removeDir().RDir(" + remotePath + ")");
        IClient storage = GCUBEStorage.getStorage(portalLogin, serviceName);
        storage.removeDir().RDir(remotePath);
    }

    public static String putStream(InputStream is, String new_remotePath, String portalLogin, String serviceName) throws RemoteBackendException {
        logger.trace("GCUBE Storage - putStream - remotePath: " + new_remotePath);
        IClient storage = GCUBEStorage.getStorage(portalLogin, serviceName);
        storage.put(true).LFile(is).RFile(new_remotePath);
        try {
            is.close();
            logger.trace("GCUBE Storage inputStream closed");
        }
        catch (IOException e) {
            logger.error("GCUBE Storage error during to close inputStream", (Throwable)e);
        }
        return GCUBEStorage.getStorage(portalLogin).getUrl().RFile(new_remotePath);
    }

    private static IClient getStorage(String portalLogin, String serviceName) {
        IClient storage = null;
        logger.trace("Calling GCUBEStorage from user: " + portalLogin + " - serviceName: " + serviceName);
        try {
            String currentScope = ScopeProvider.instance.get();
            String scope = Utils.getRootScope(currentScope);
            ScopeProvider.instance.set(scope);
            logger.trace("GCUBE Storage scope : " + scope);
            storage = new StorageClient("org.gcube.portlets.user", serviceName, portalLogin, AccessType.SHARED, currentScope, false).getClient();
            Handler.activateProtocol();
        }
        catch (Exception e) {
            logger.error("GCUBE Storage initialization failed", (Throwable)e);
        }
        return storage;
    }

    public static long getRemoteFileSize(String remotePath, String portalLogin, String serviceName) throws RemoteBackendException {
        logger.trace("GCUBE Storage getRemoteFileSize - storage.getSize().RFile(" + remotePath + ")");
        IClient storage = GCUBEStorage.getStorage(portalLogin, serviceName);
        long size = storage.getSize().RFile(remotePath);
        return size;
    }
}

