/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.repository.external.GCUBEStorage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRead;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryShare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryType;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUnshare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.util.MimeTypeUtil;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRFile
implements org.gcube.common.homelibrary.home.workspace.folder.items.File {
    private static Logger logger = LoggerFactory.getLogger(JCRFile.class);
    public static final String MIME_TYPE = "jcr:mimeType";
    public static final String DATA = "jcr:data";
    public static final String SIZE = "hl:size";
    public static final String REMOTE_STORAGE_PATH = "hl:remotePath";
    public static final String STORAGE_PATH = "hl:storagePath";
    protected String nodeId;
    private String mimeType;
    private long size;
    public String portalLogin;
    public File tmpFile;

    public JCRFile(JCRWorkspace workspace, Node node) throws RepositoryException {
        this.portalLogin = workspace.getOwner().getPortalLogin();
        this.nodeId = node.getIdentifier();
        try {
            this.mimeType = node.getProperty(MIME_TYPE).getString();
        }
        catch (Exception e) {
            this.mimeType = "application/octet-stream";
        }
        this.size = node.getProperty(SIZE).getLong();
    }

    public JCRFile(JCRWorkspace workspace, Node node, String mimeType, InputStream data) throws RepositoryException, RemoteBackendException {
        this.tmpFile = WorkspaceUtil.getTmpFile((InputStream)data);
        try {
            data.close();
        }
        catch (IOException e1) {
            logger.error("Error closing InputStream " + e1);
        }
        this.portalLogin = workspace.getOwner().getPortalLogin();
        this.mimeType = mimeType;
        this.size = this.tmpFile.length();
        String remotePath = Text.getRelativeParent((String)Text.unescapeIllegalJcrChars((String)node.getPath()), (int)1);
        ByteArrayInputStream binaryUrl = new ByteArrayInputStream(node.getPath().getBytes());
        Binary binary = node.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
        node.setProperty(DATA, binary);
        String url = null;
        try {
            FileInputStream is = new FileInputStream(this.tmpFile);
            url = GCUBEStorage.putStream(is, remotePath, workspace.getOwner().getPortalLogin());
            is.close();
        }
        catch (IOException e) {
            logger.error("FileNotFoundException " + e);
        }
        this.setProperties(node, remotePath, mimeType, this.size);
        logger.trace("GCUBEStorage URL : " + url);
    }

    public JCRFile(JCRWorkspace workspace, Node node, String mimeType, File tmpFile) throws RepositoryException, RemoteBackendException {
        this.tmpFile = tmpFile;
        this.portalLogin = workspace.getOwner().getPortalLogin();
        this.mimeType = mimeType;
        this.size = tmpFile.length();
        String remotePath = Text.getRelativeParent((String)Text.unescapeIllegalJcrChars((String)node.getPath()), (int)1);
        ByteArrayInputStream binaryUrl = new ByteArrayInputStream(node.getPath().getBytes());
        Binary binary = node.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
        node.setProperty(DATA, binary);
        String url = null;
        try {
            FileInputStream is = new FileInputStream(tmpFile);
            url = GCUBEStorage.putStream(is, remotePath, workspace.getOwner().getPortalLogin());
            is.close();
        }
        catch (IOException e) {
            logger.error("FileNotFoundException " + e);
        }
        this.setProperties(node, remotePath, mimeType, this.size);
        logger.trace("GCUBEStorage URL : " + url);
    }

    private void setProperties(Node node, String remotePath, String mimeType, long size) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        node.setProperty(REMOTE_STORAGE_PATH, remotePath);
        node.setProperty(SIZE, size);
        node.setProperty(MIME_TYPE, mimeType);
    }

    public void save(Node node) throws RepositoryException {
        this.nodeId = node.getIdentifier();
        try {
            logger.trace("***delete " + this.tmpFile.getAbsolutePath());
            this.tmpFile.delete();
        }
        catch (Exception e) {
            logger.debug("no tmpFile for node " + node.getPath());
        }
    }

    public JCRFile(JCRWorkspace workspace, Node node, InputStream data) throws RepositoryException, RemoteBackendException {
        this(workspace, node, MimeTypeUtil.getMimeType((String)node.getName(), (InputStream)data), data);
    }

    public JCRFile(JCRWorkspace workspace, Node node, InputStream data, String mimeType) throws RepositoryException, RemoteBackendException {
        this(workspace, node, mimeType, data);
    }

    public String getName() throws InternalErrorException {
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            String string = node.getName();
            return string;
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getData() throws InternalErrorException {
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            try {
                remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
            }
            catch (PathNotFoundException e) {
                logger.trace("Old retrieve content method");
            }
            if (remotePath != null) {
                logger.trace("Content retrieved from remote storage...");
                InputStream stream = null;
                try {
                    stream = GCUBEStorage.getRemoteFile(remotePath, this.portalLogin);
                }
                catch (Exception e) {
                    logger.error("no payload for " + this.getName());
                }
                InputStream e = stream;
                return e;
            }
            Binary data = node.getProperty(DATA).getBinary();
            try {
                logger.trace("Content moved to remote storage");
                remotePath = Text.unescapeIllegalJcrChars((String)node.getPath());
                String url = GCUBEStorage.putStream(data.getStream(), remotePath, this.portalLogin);
                logger.trace("New gcube storage url : " + url);
                ByteArrayInputStream binaryUrl = new ByteArrayInputStream(url.getBytes());
                Binary binary = node.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
                node.setProperty(DATA, binary);
                node.setProperty(REMOTE_STORAGE_PATH, remotePath);
                session.save();
            }
            catch (Exception e) {
                logger.error("The item doesn't contain hl:remotePath property");
                throw new InternalErrorException((Throwable)e);
            }
            InputStream inputStream = data.getStream();
            return inputStream;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public long getLength() throws InternalErrorException {
        return this.size;
    }

    public String getPublicLink() throws InternalErrorException {
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            try {
                remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
            }
            catch (PathNotFoundException e) {
                logger.trace("No public link for file: " + node.getPath());
            }
            if (remotePath == null) {
                Binary data = node.getProperty(DATA).getBinary();
                try {
                    remotePath = Text.unescapeIllegalJcrChars((String)node.getPath());
                    logger.debug("Moving to remote storage: " + remotePath);
                    String url = GCUBEStorage.putStream(data.getStream(), remotePath, this.portalLogin);
                    logger.debug("New gcube storage url : " + url);
                    ByteArrayInputStream binaryUrl = new ByteArrayInputStream(url.getBytes());
                    Binary binary = node.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
                    node.setProperty(DATA, binary);
                    node.setProperty(REMOTE_STORAGE_PATH, remotePath);
                    session.save();
                }
                catch (Exception e) {
                    logger.error("The item doesn't contain hl:remotePath property");
                }
            }
            String string = GCUBEStorage.getPublicLink(remotePath, this.portalLogin);
            return string;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void getHardLink(String destPath) throws InternalErrorException {
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            try {
                remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
            }
            catch (PathNotFoundException e) {
                logger.trace("No public link for file: " + node.getPath());
            }
            GCUBEStorage.createHardLink(remotePath, destPath, this.portalLogin);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    public void updateInfo(String mimeType, long size) throws InternalErrorException {
        String remotePath = null;
        Session session = JCRRepository.getSession();
        try {
            Node node = session.getNodeByIdentifier(this.nodeId);
            try {
                remotePath = node.getProperty(REMOTE_STORAGE_PATH).getString();
                logger.trace(node.getPath() + " - mimeType: " + mimeType);
                this.setProperties(node, remotePath, mimeType, size);
                session.save();
            }
            catch (PathNotFoundException e) {
                logger.trace("No public link for file: " + node.getPath());
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<AccountingEntry> getAccounting(Node node) {
        ArrayList<AccountingEntry> list = new ArrayList<AccountingEntry>();
        Session session = null;
        try {
            session = JCRRepository.getSession();
            Node accountingNode = node.getNode("hl:accounting");
            NodeIterator iterator = accountingNode.getNodes();
            while (iterator.hasNext()) {
                Node entryNode = (Node)iterator.next();
                try {
                    switch (JCRAccountingEntryType.getEnum(entryNode.getPrimaryNodeType().getName())) {
                        case CUT: {
                            list.add(new JCRAccountingFolderEntryCut(entryNode));
                            break;
                        }
                        case PASTE: {
                            list.add(new JCRAccountingEntryPaste(entryNode));
                            break;
                        }
                        case REMOVAL: {
                            list.add(new JCRAccountingFolderEntryRemoval(entryNode));
                            break;
                        }
                        case RENAMING: {
                            list.add(new JCRAccountingEntryRenaming(entryNode));
                            break;
                        }
                        case ADD: {
                            list.add(new JCRAccountingFolderEntryAdd(entryNode));
                            break;
                        }
                        case UPDATE: {
                            list.add(new JCRAccountingEntryUpdate(entryNode));
                            break;
                        }
                        case READ: {
                            list.add(new JCRAccountingEntryRead(entryNode));
                            break;
                        }
                        case SHARE: {
                            list.add(new JCRAccountingEntryShare(entryNode));
                            break;
                        }
                        case UNSHARE: {
                            list.add(new JCRAccountingEntryUnshare(entryNode));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Accounting entry skipped " + entryNode.getPrimaryNodeType().getName(), (Throwable)e);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return list;
    }
}

