/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRGroup;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRUserManager
implements UserManager {
    private Logger logger = LoggerFactory.getLogger(JCRUserManager.class);
    public static final String PORTAL_LOGIN = "hl:portalLogin";
    protected static final String ACCOUNTING = "hl:accounting";
    protected static final String NT_ACCOUNTING = "nthl:accountingSet";
    private static final String SPECIAL_FOLDER_PATH = "/Workspace/MySpecialFolders/";
    public static String url;

    public JCRUserManager() {
        url = JCRRepository.url;
    }

    public List<GCubeGroup> getGroups() throws InternalErrorException {
        ArrayList<GCubeGroup> groupsList = null;
        List list = null;
        GetMethod getMethod = null;
        try {
            groupsList = new ArrayList<GCubeGroup>();
            HttpClient httpClient = new HttpClient();
            this.logger.info(url);
            getMethod = new GetMethod(url + "/ListGroupsServlet");
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.trace("Callin List Groups Servlet");
            XStream xstream = new XStream();
            list = (List)xstream.fromXML(getMethod.getResponseBodyAsString());
            for (String group : list) {
                groupsList.add(new JCRGroup(group));
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return groupsList;
    }

    public Boolean isGroup(String groupId) throws InternalErrorException {
        Boolean found = false;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/IsGroupServlet?groupName=" + groupId);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.trace("Is " + groupId + " a group? " + getMethod.getResponseBodyAsString());
            XStream xstream = new XStream();
            found = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return found;
    }

    public GCubeGroup getGroup(String groupId) throws InternalErrorException {
        JCRGroup group = null;
        try {
            if (this.isGroup(groupId).booleanValue()) {
                group = new JCRGroup(groupId);
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCubeGroup createGroup(String scope) throws InternalErrorException {
        this.logger.trace("Create a new group: " + scope);
        String newGroupName = Utils.getGroupByScope(scope);
        String displayName = this.getDisplayName(scope);
        GetMethod getMethod = null;
        JCRGroup group = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/CreateGroupServlet?groupName=" + newGroupName + "&displayName=" + displayName);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.trace("Create Group " + newGroupName);
            this.logger.trace("Response " + getMethod.getResponseBodyAsString());
            try {
                group = new JCRGroup(newGroupName);
            }
            catch (Exception e) {
                this.logger.error("Error creating a new group ", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return group;
    }

    private String getDisplayName(String groupName) {
        String[] groupNameSplit = groupName.split("/");
        int size = groupNameSplit.length;
        String displayName = groupNameSplit[size - 1];
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAuthorizable(String groupName) throws InternalErrorException {
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/DeleteAuthorizableServlet?groupName=" + groupName);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.trace("Delete user or group " + groupName);
            this.logger.trace("Response " + getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error removing User or group in UserManager", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return true;
    }

    public List<String> getUsers() throws InternalErrorException {
        List users = null;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/ListUsersServlet");
            httpClient.executeMethod((HttpMethod)getMethod);
            XStream xstream = new XStream();
            users = (List)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createUser(String name, String version) throws InternalErrorException {
        Boolean created = false;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            String pass = JCRUserManager.getSecurePassword(name);
            getMethod = new GetMethod(url + "/CreateUserServlet?userName=" + name + "&pwd=" + pass);
            httpClient.executeMethod((HttpMethod)getMethod);
            XStream xstream = new XStream();
            created = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
            this.logger.trace("Create User " + name);
            this.logger.trace("Response " + created);
        }
        catch (Exception e) {
            this.logger.error("Error retrieving Users in UserManager", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createUser(String name, String pass, String version) throws InternalErrorException {
        Boolean created = false;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/CreateUserServlet?userName=" + name + "&pwd=" + pass);
            httpClient.executeMethod((HttpMethod)getMethod);
            XStream xstream = new XStream();
            created = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
            this.logger.trace("Create User " + name);
            this.logger.trace("Response " + created);
        }
        catch (Exception e) {
            this.logger.error(name + " already exists", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return created;
    }

    public static String getSecurePassword(String message) throws InternalErrorException {
        String digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(message.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            digest = sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return digest;
    }

    public boolean associateUserToGroup(String scope, String username, String portalLogin) throws InternalErrorException, ItemNotFoundException {
        block10: {
            String VREFolder;
            HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
            UserManager gm = factory.getUserManager();
            String groupId = VREFolder = Utils.getGroupByScope(scope);
            String manager = this.getManager(VREFolder);
            try {
                GCubeGroup group;
                if (gm.createUser(username, null)) {
                    this.logger.trace(username + " has been created");
                }
                if ((group = gm.getGroup(groupId)) != null) {
                    group.addMember(username);
                }
                Workspace ws = null;
                try {
                    ws = factory.getHomeManager().getHome(manager).getWorkspace();
                }
                catch (WorkspaceFolderNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (HomeNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                catch (UserNotFoundException e) {
                    throw new InternalErrorException((Throwable)e);
                }
                if (ws == null) break block10;
                WorkspaceSharedFolder folder = (WorkspaceSharedFolder)ws.getItemByPath(SPECIAL_FOLDER_PATH + VREFolder);
                this.logger.trace("VRE folder path: " + folder.getPath());
                ArrayList<String> user = new ArrayList<String>();
                user.add(username);
                try {
                    folder.share(user);
                }
                catch (InsufficientPrivilegesException | WrongDestinationException e) {
                    throw new InternalErrorException(e);
                }
            }
            catch (InternalErrorException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUserFromGroup(String scope, String userToRemove, String portalLogin) throws InternalErrorException, ItemNotFoundException {
        String VREFolder;
        UserManager gm = HomeLibrary.getHomeManagerFactory().getUserManager();
        String groupId = VREFolder = Utils.getGroupByScope(scope);
        String manager = this.getManager(VREFolder);
        try {
            GCubeGroup group = gm.getGroup(groupId);
            if (group != null) {
                group.removeMember(userToRemove);
            }
            Workspace ws = null;
            try {
                ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(manager).getWorkspace();
            }
            catch (WorkspaceFolderNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (HomeNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (UserNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            if (ws != null) {
                WorkspaceSharedFolder folder = (WorkspaceSharedFolder)ws.getItemByPath(SPECIAL_FOLDER_PATH + VREFolder);
                this.logger.trace("VRE folder path: " + folder.getPath());
                folder.unShare(userToRemove);
            }
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public boolean setAdministrator(String scope, String username, String portalLogin) throws InternalErrorException, ItemNotFoundException {
        String VREFolder = Utils.getGroupByScope(scope);
        Workspace ws = null;
        String manager = this.getManager(VREFolder);
        try {
            ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(manager).getWorkspace();
            WorkspaceSharedFolder folder = (WorkspaceSharedFolder)ws.getItemByPath(SPECIAL_FOLDER_PATH + VREFolder);
            ArrayList<String> administator = new ArrayList<String>();
            administator.add(username);
            folder.setACL(administator, ACLType.ADMINISTRATOR);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean removeAdministrator(String scope, String username, String portalLogin) throws InternalErrorException, ItemNotFoundException {
        String VREFolder = Utils.getGroupByScope(scope);
        Workspace ws = null;
        String manager = this.getManager(VREFolder);
        try {
            ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(manager).getWorkspace();
            WorkspaceSharedFolder folder = (WorkspaceSharedFolder)ws.getItemByPath(SPECIAL_FOLDER_PATH + VREFolder);
            ArrayList<String> administator = new ArrayList<String>();
            administator.add(username);
            folder.deleteACL(administator);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String getManager(String scope) {
        String manager = scope + "-Manager";
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersionByUser(String user) throws InternalErrorException {
        String displayName;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/GetVersionServlet?user=" + user);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            XStream xstream = new XStream();
            displayName = (String)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setVersionByUser(String user, String version) throws InternalErrorException {
        boolean flag;
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            getMethod = new GetMethod(url + "/SetVersionServlet?user=" + user + "&version=" + version);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            flag = true;
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return flag;
    }
}

